/***************************************************************************
                          configdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 2 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include "khconfigitem.h"
#include "khfeatureprofile.h"
#include "khtab1.h"
#include "khbuttonpair.h"

KHTab1::KHTab1( QWidget *parent, const char *name) : QWidget( parent, name ){

	config = kapp->getConfig();

	if ( KHFeatureProfile::checkFeature( BeepControl ) )
		grid = new QGridLayout( this, 1, 5 );
	else
		grid = new QGridLayout( this, 1, 4 );
	KHConfigItem::setLayout( grid );

	grid->setColStretch( 0, 0 );
	grid->addColSpacing( 0, 20 );
	grid->setColStretch( 1, 1 );
	grid->setColStretch( 2, 1 );
	grid->addColSpacing( 2, 60 );
	grid->setColStretch( 3, 1 );
	grid->addColSpacing( 3, 60 );

	grid->setRowStretch( 0, 0 );
	grid->addRowSpacing( 0, 35 );

	QLabel *l = new QLabel( "Enable", this );
	l->setMinimumSize( l->sizeHint() );
	l->setMaximumSize( l->sizeHint().width() + 10, l->sizeHint().height() + 10 );
	grid->addWidget( l, 0, 2, AlignCenter );

	l = new QLabel( "Faults\n1     3", this );
	l->setMinimumSize( l->sizeHint() );
	l->setMaximumSize( l->sizeHint().width() + 10, l->sizeHint().height() + 10 );
	grid->addWidget( l, 0, 3, AlignCenter );

	if ( KHFeatureProfile::checkFeature( BeepControl ) ) {
		l = new QLabel( "Beeping", this );
		l->setMinimumSize( l->sizeHint() );
		l->setMaximumSize( l->sizeHint().width() + 10, l->sizeHint().height() + 10 );
		grid->setColStretch( 4, 1 );
		grid->addColSpacing( 4, 60 );
		grid->addWidget( l, 0, 4, AlignCenter );
	}


	for ( SensorId sid = Fan1; sid < SensorIdSize; sid++ )
		if ( KHFeatureProfile::checkFeature( sid ) ) {
				items[sid] = new KHConfigItem( sid, this );
		}
		else items[sid] = 0;


	// check which sensors should be monitored and press their buttons

	config->setGroup( "Monitoring" );
	for ( SensorId sid = Fan1; sid < SensorIdSize; sid++ )
		if ( KHFeatureProfile::checkFeature( sid ) ) {
			items[sid]->setEnableButton( config->readBoolEntry( EnableKeys[sid], false ) );
			connect( items[sid],SIGNAL( clicked		( KHConfigItem::ButtonId ) ),
					 			this,		 	SLOT	( configure	( KHConfigItem::ButtonId ) ) );			
		}

	// check which beeps should be enabled and press their buttons

	config->setGroup( "Beeping" );
	for ( SensorId sid = Fan1; sid < SensorIdSize; sid++ )
		if ( ( KHFeatureProfile::checkFeature( sid ) ) && ( items[sid]->hasBeepButton() ) )
			items[sid]->setBeepButton( config->readBoolEntry( BeepKeys[sid], false ) );

	// check how many faults should be detected for an alarm and press appropriate buttons

	config->setGroup( "NumFaults" );
	for ( SensorId sid = Fan1; sid < SensorIdSize; sid++ )
		if ( KHFeatureProfile::checkFeature( sid ) )
			items[sid]->setFaultsButton( config->readNumEntry( FaultsKeys[sid], 3 ) );

	resize( 100, 100 );

	grid->activate();
}

KHTab1::~KHTab1(){
	//debug( "destroying KHTab1" );
	/*delete QBGroup_Beep;
	delete QBGroup_Enable;
	for ( int i = 0; i < 13; i++ )
		delete QBGroup_Faults->find( i );
	delete QBGroup_Faults;
	delete[] cbArr;
	delete d;*/
}

void KHTab1::configure( KHConfigItem::ButtonId button ) {

	SensorId sid = End;

	for ( SensorId i = Fan1; i < SensorIdSize; i++ )
		if ( sender() == items[i] ) sid = i;

	if ( sid == End ) {
		debug( "KHTab1: signal from unknown sender caught" );
		return;
	}

	switch ( button ) {
		case KHConfigItem::ButtonEnable:
			config->setGroup( "Monitoring" );
			config->writeEntry( EnableKeys[sid], items[sid]->enableIsActivated() );
			emit enableSettingChanged( items[sid]->enableIsActivated(), sid );
		break;
		case KHConfigItem::ButtonBeep:
			config->setGroup( "Beeping" );
			config->writeEntry( BeepKeys[sid], items[sid]->beepIsActivated() );
			emit beepSettingChanged( items[sid]->beepIsActivated(), sid );
		break;
		case KHConfigItem::ButtonFaultsLeft:
			config->setGroup( "NumFaults" );
			config->writeEntry( FaultsKeys[sid], 1 );
			emit faultsSettingChanged( 1, sid );
		break;
		case KHConfigItem::ButtonFaultsRight:
			config->setGroup( "NumFaults" );
			config->writeEntry( FaultsKeys[sid], 3 );
			emit faultsSettingChanged( 3, sid );
		break;
		default:
			// do nothing
		break;
	}
}

/**  */
void KHTab1::createRow( SensorId sid ){
	
	static int itemCount;

	if ( sid == Fan1 ) itemCount = 1;
	else itemCount++;
	if ( itemCount ) grid->expand( itemCount + 1, grid->numCols() );

	label[sid] = new QLabel ( KHFeatureProfile::name( sid ) , this );
	label[sid]->setMinimumSize( label[sid]->sizeHint() );
	label[sid]->setMaximumSize( label[sid]->sizeHint().width() + 10, label[sid]->sizeHint().height() + 10 );
	label[sid]->setFixedWidth( 50 );
	grid->addWidget( label[sid], itemCount, 1, AlignLeft );

	enable[sid] = new QCheckBox( this );
	enable[sid]->setMinimumSize( enable[sid]->sizeHint() );
	enable[sid]->setMaximumSize( enable[sid]->sizeHint().width() + 10, enable[sid]->sizeHint().height() + 10 );
  grid->addWidget( enable[sid], itemCount, 2, AlignCenter );
	connect( enable[sid],SIGNAL( clicked() ),
					 this, 	SLOT	( forwardClick() ) );
	QToolTip::add( enable[sid], QString( "enable[sid] / disable " ).append( KHFeatureProfile::name( sid ) ).append( " monitoring" ) );

	faults[sid] = new KHButtonPair( this );
	faults[sid]->setMinimumSize( faults[sid]->size() );
	faults[sid]->setMaximumSize( faults[sid]->size().width() + 10, faults[sid]->size().height() + 10 );
	grid->addWidget( faults[sid], itemCount, 3, AlignCenter );
  connect( faults[sid],SIGNAL( clicked() ),
					 this, 	SLOT	( forwardClick() ) );
	QToolTip::add( faults[sid], QString( "set " ).append( KHFeatureProfile::name( sid ) ).append( " to 1 or 3 consecutive faults" ) );

	if ( KHFeatureProfile::checkFeature( BeepControl ) ) {
		beep[sid] = new QCheckBox( this );
		beep[sid]->setMinimumSize( beep[sid]->sizeHint() );
		beep[sid]->setMaximumSize( beep[sid]->sizeHint().width() + 10, beep[sid]->sizeHint().height() + 10 );
		grid->addWidget( beep[sid], itemCount, 4, AlignCenter );
		connect( beep[sid], SIGNAL	( clicked() ),
 						 this, SLOT	 	( forwardClick() ) );
		QToolTip::add( beep[sid], QString( "enable / disable beeping for " ).append( KHFeatureProfile::name( sid ) ) );
	}
	else beep[sid] = 0;

}










