/***************************************************************************
                          kinstall.h  -  KInstall Main Window (Header)
                             -------------------                                         
    begin                : Sat Apr 10 01:24:55 WEST 1999
    copyright            : (C) 1999 by Hugo Santos
    email                : hugo_santos@bigfoot.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KINSTALL_H
#define KINSTALL_H

#include <kapp.h>
#include <ktmainwindow.h>
#include <kmsgbox.h>
#include <kprocess.h>
#include <kfiledialog.h>
#include <kwizard.h>

#include <qlistbox.h>
#include <qfile.h>
#include <qdir.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qdialog.h>
#include <qmultilinedit.h>

#include <stdio.h>

#include "stuff.h"

class _Page;

class _KInstall : public KTMainWindow {
  Q_OBJECT 
public: 
  _KInstall( QString );
  ~_KInstall();
	void setPage( _Page *page=0 );
	QPushButton * getButtonOk();
	QPushButton * getButtonCancel();
	QPushButton * getButtonHelp();
	QPushButton * getButtonNext();
	QPushButton * getButtonBack();
	QLabel * getLabelTitle();
	QLabel * getLabelImage();
	void setButtonOk( const char * );
	void setButtonCancel( const char * );
	void setButtonHelp( const char * );
	void setButtonNext( const char * );
	void setButtonBack( const char * );
	void setButtonOkEnabled( bool tf );
	void setButtonCancelEnabled( bool tf );
	void setButtonHelpEnabled( bool tf );
	void setButtonNextEnabled( bool tf );
	void setButtonBackEnabled( bool tf );
	void setTitleFont( const char * family, int pointSize = 22, int weight = QFont::Bold, bool italic = true );
	void setTitle( const char * );
	void setImage( QPixmap );
	struct {
		QString name;
		QString argv;
		QString wheretoinstall;
		QString inside_tempdir;
		QString xtrargs;
		int type;
	}inst;
	void errorForceQuit(QString error_description);
public slots:
	void slotClean();
	bool slotDoesThisInstHaveADir();
signals:
	void okclicked();
	void cancelclicked();
	void helpclicked();
	void nextclicked();
	void backclicked();
private slots:
	void slotOkClicked();
	void slotCancelClicked();
	void slotHelpClicked();
	void slotNextClicked();
	void slotBackClicked();
private:
	void reArrange();
	QPushButton *_OkButton;
	QPushButton *_CancelButton;
	QPushButton *_HelpButton;
	QPushButton *_NextButton;
	QPushButton *_BackButton;
	QLabel *_title;
	QLabel *_image;
	_Page *_page;
protected:
	void resizeEvent( QResizeEvent *e );
};

class _Page : public QWidget {
   Q_OBJECT
public:
	_Page(_KInstall *parent=0, const char *name=0);
	~_Page();
	_KInstall *ki;
signals:
	void finished();
	void finished2();
};

#endif