#	$Id: GLOBAL.sh,v 1.1 1999/08/27 07:29:56 stephan Exp $

# apsfilters version number
VERSION=511

# NOTIFY whon in case of printer fault
NOTIFY=root

# possible PATH's ... is that enough ?! :)
# $APS_BASEDIR/bin not needed, since a2ps and rewindstdin have gone
APS_PATH=$APS_BASEDIR/setup:$APS_BASEDIR/global
STD_PATH=/sbin:/bin:/usr/sbin:/usr/bin:/usr/contrib/bin
TEX_PATH_U=/usr/TeX/bin:/usr/local/TeX/bin:/TeX/bin:/usr/local/teTeX/bin
TEX_PATH_L=/usr/tex/bin:/usr/local/lib/{tex,mf}/bin:/tex/bin
SUN_PATH=/usr/ucb:/usr/openwin/bin:/usr/etc:/etc
GNU_PATH=/usr/gnu/bin:/gnu/bin:/usr/gnu
X11_PATH=/usr/bin/X11:/usr/X386/bin:/usr/X11/bin:/usr/X11R6/bin
WUP_PATH=/wup/bin
COMMON_PATH=/usr/local/bin:/local/bin
# HERE IS THE TEMPLATE FOR YOU TO ADD PATHS THAT ARE ADDITIONALLY NEEDED !!!
LOCAL_PATH=/foo/bar

PATH=$APS_PATH:$STD_PATH:$TEX_PATH_U:$TEX_PATH_L:\
$SUN_PATH:$GNU_PATH:$X11_PATH:$WUP_PATH:$COMMON_PATH:$LOCAL_PATH:.
export PATH

OLDCAP=/etc/printcap.old

# APS_BASEDIR is computed from /etc/printcap in apsfilter script
FILTERS_FOUND=$APS_BASEDIR/global/filters_found

# Try to get the correct spool dir and permissions
# the different Linux Systems do have differen permissions
# Hope we can manage things this way !!!

if [ -d /var/spool/lpd ]; then
	SPOOL=/var/spool/lpd
elif [ -d /var/spool ]; then
	SPOOL=/var/spool
else
	# create spool
	# assume owner lp, daemon or root
	SPOOL=/var/spool
	mkdir -p ${SPOOL}
	chown lp ${SPOOL} \
	|| chown daemon ${SPOOL} \
	|| chown root ${SPOOL}
fi

# drwxr-xr-x  9 root  wheel  512 13 Feb 14:20 /var/spool
# $1          $2 $3   $4

set -- `ls -ld ${SPOOL}`
LP_OWNER=$3
LP_GROUP=$4

SYSTEM=`uname -s`
case $SYSTEM in
	*SunOS*|*sunos*|*SUNOS*)
					MAGIC=/etc/magic
					;;
	BSD/386)			
					MAGIC=/usr/share/misc/magic
					;;
	*BSD)				
					MAGIC=/etc/magic
					;;
	Linux)			
					MAGIC=/etc/magic
					;;
	*)				
					MAGIC=/etc/magic
					;;
esac

if [ -f /bin/less -o -f /usr/bin/less -o -f /usr/local/bin/less -o -f /usr/contrib/bin/less ]; then
	PAGER=less
else
	PAGER=more
fi

#
# how to suppress newlines on echo command for nicer display ...
#
c=''
n=''
# first determine how to suppress newline on echo command
(echo "hi there\c" ; echo " ") > /tmp/.echotmp
if grep c /tmp/.echotmp >/dev/null 2>&1 ; then
    n='-n'
    c=''
else
    n=''
    c='\c'
fi
rm -f /tmp/.echotmp
