/***************************************************************************
    $Id: apsfilter.h,v 1.1 1999/09/14 00:26:24 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: apsfilter.h,v $
    Revision 1.1  1999/09/14 00:26:24  wdl
    Restructuring of directories

    Revision 1.5  1999/09/12 10:28:11  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.4  1999/08/27 16:43:00  wdl
    Standard Headers

 ***************************************************************************/
#ifndef APSFILTER_H
#define APSFILTER_H

#include <qstring.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qtextstream.h>
#include <stdlib.h>

#include "apsfilterconfig.h"

/**
  *@author Stephan Heigl
  */

class apsfilter {
public: 
	apsfilter(const char *); // first arg:dir to apsfilter 2nd: path to printer filter link dir :)
	~apsfilter(); // destructor
	void setPathToAPS(const char *val) { PathToAPS = val; } // dir to the apsfilter script
	void setPathToFilter(const char *val) { PathToFilter = val; }   // dir in which the printer filter should be created (the link)
	bool setup(apsfilterConfig &cfg); // create the /etc/apsfilter.gsdriver if necessary and create the links to the apsfilter exec.

	const char * getFilterName() { return FilterName.data(); }
	const char * getFltName() { return FltName.data(); }
	const char * getPathToFilter() { return PathToFilter.data(); }
private:
	QString PathToAPS,FltName;
	QString PathToFilter;
	QString FilterName;
};

#endif













