/***************************************************************************
    $Id: kpcapi.h,v 1.5 1999/10/03 14:04:36 stephan Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: kpcapi.h,v $
    Revision 1.5  1999/10/03 14:04:36  stephan
    Cleanup.

    Revision 1.4  1999/09/30 20:46:47  wdl
    fixed some things with pointers in kpclib for removeprinter

    Revision 1.3  1999/09/20 13:40:52  stephan
    Added a filter for KpcAPI::getInstalledPrinters

    Revision 1.2  1999/09/19 13:45:15  wdl
     name change getInstalledPrinter to getInstalledPrinters

    Revision 1.1  1999/09/14 00:26:25  wdl
    Restructuring of directories

    Revision 1.7  1999/09/12 10:28:12  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.6  1999/08/27 16:43:01  wdl
    Standard Headers

 ***************************************************************************/
#ifndef KPCAPI_H
#define KPCAPI_H

#include <kapp.h>
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdir.h>
#include <qregexp.h>
#include <ksimpleconfig.h>
#include <qmessagebox.h>

#include "kpcprinter.h"
#include "apsfilter.h"
#include "apsfilterconfig.h"
#include "printerdb.h"
#include "printerdbentry.h"
#include "printcap.h"
#include "printcapentry.h"

#include "lpdfilter.h"
#include "smbfilter.h"

/**
	* API to kpclib
	*
	* Provides easy access to KpcLibs different parts. Only setup printerqueues for
	* each color/mono resolution and a ascii queue will be configurable in the future
	*
  * @author Stephan Heigl
  **/

class KpcAPI {
public: 
/**
  * Constructor. Load the printer db.
	**/
	KpcAPI();
	~KpcAPI();
/**
	* Get the Manufactors from the db.
	*
	* @return List of QStrings with all Manufactor from the db
	**/
	QList<QString> getManufactorList();

/**
 * Returns the names of printers from a manufactor.
 *	It takes a <i>const char *</i> value which means the manufactor.
 *
 * @return List of QStrings with printernames from the specified manufactor
 **/
	QList<QString> getPrinterLst(const char *);

/**
	* Returns the names of the installed printers. Local as well as network.
	*
	* @return List of QStrings with installed printers
	**/
	QList<QString> getInstalledPrinters();
/**
	* Returns the names of the installed printers. But only those of the specified type (local,smb,appletalk...)
	*
	* @return List of QStrings with installed printers
	**/
	QList<QString> getInstalledPrinters(KpcPrinter::netType);
 /**
	* Add a printer to the local db. It takes a <i>KpcPrinter</i> value.
	*	@see KpcPrinter
	* Doesnt create any printcap entries or apsfilter links yet. You have to use KpcAPI::snyc() to apply changes.
	*
	**/
	void addPrinter(KpcPrinter *);

/**
	* Remove a printer from the db, and remove its spool dir(s). It takes a <i>KpcPrinter</i> value.
	* @see KpcPrinter
	**/
	void removePrinter(KpcPrinter *);

/**
	* Remove a printer. It takes a <i>int</i> lvalue.
	**/
  void removePrinter(int no);

/**
	* Install spool dirs, apsfilters and printcap.
	*
	* Call this if you have added/removed all your printers and want to write it to disk.
	**/
	void sync();

/**
	* Set error handling either by the lib or by return values.
	* It takes a <i>bool</I> value.
	*
	* If true, KpcLib handle errors otherwise the user have to handle this stuff.
	**/
	void handleErrors(bool);

private:
	bool isDbNamePresent(const char *);

  KSimpleConfig *t_cfg;
	int pn;
	printerDB *tmpPrinterDB;
	QList<KpcPrinter> installedPrinter;
	QFile *t_file;
};
#endif





























