/***************************************************************************
    $Id: printcapentry.cpp,v 1.1 1999/09/14 00:26:27 wdl Exp $
    copyright : (C) 1999 by Stephan Heigl       <stephan@heigl-gmbh.de>
                (C) 1999 by Willy De la Court   <Willy.DelaCourt@pandora.be>
 ***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************
    $Log: printcapentry.cpp,v $
    Revision 1.1  1999/09/14 00:26:27  wdl
    Restructuring of directories

    Revision 1.4  1999/09/12 10:28:12  stephan
    Bugfixes and some changes for the shared lib

    Revision 1.3  1999/08/27 16:43:02  wdl
    Standard Headers

 ***************************************************************************/
#include <assert.h>
#include "printcapentry.h"

/*
printcapEntry::printcapEntry(const char *name,const char *spooldir,const char *filtername,const char *logfile,const char *account){
	SpoolName = name;
	FilterName = filtername;
	SpoolDir = spooldir;
  LogFile = logfile;
	AccountFile = account;
}
*/

printcapEntry::printcapEntry(printcapEntry & pc_to_cp){
	SpoolName = pc_to_cp.getSpoolName();
	FilterName = pc_to_cp.getFilterName();
	SpoolDir = pc_to_cp.getSpoolDir();
	LogFile = pc_to_cp.getLogFile();
	AccountFile = pc_to_cp.getAccountFile();
	PrinterPort = pc_to_cp.getPrinterPort();
	RemoteMachine = pc_to_cp.getRemoteMachine();
	RemotePrinterName = pc_to_cp.getRemotePrinterName();
	SpoolNameAlias = pc_to_cp.getAliasList();
}

printcapEntry::printcapEntry()
{
}

printcapEntry::~printcapEntry(){
}

void printcapEntry::updateSpoolName(){
	QString *tmpStr = new QString;
	SpoolName = "";
	for(tmpStr = SpoolNameAlias.first(); tmpStr !=0; tmpStr = SpoolNameAlias.next()) {
 		SpoolName = SpoolName.append(tmpStr->data());
		SpoolName = SpoolName.append("|");
	}

	SpoolName.truncate(SpoolName.length()-1);
	delete(tmpStr);
}

void printcapEntry::updateAlias(){
	QString *tmpStr = new QString;
  SpoolNameAlias.clear();
	for (	*tmpStr = strtok(SpoolName.data(),"|"); *tmpStr != NULL; *tmpStr = strtok(NULL,"|")){
		SpoolNameAlias.append(new QString(*tmpStr));
	}
	delete(tmpStr);
}

bool printcapEntry::isDefaultQueue(){
	if(SpoolNameAlias.contains(new QString("lp")) != 0) {return true; }else{return false; }
}

void printcapEntry::setDefaultQueue(bool flag){
	if((!isDefaultQueue()) && (flag)){
		SpoolNameAlias.insert(0,new QString("lp"));
		updateSpoolName();
	}
	if(!flag) { SpoolNameAlias.remove(*(QString)"lp"); updateSpoolName(); }
}

bool printcapEntry::isNetworkPrinter(){
	if(RemoteMachine.isNull() || RemotePrinterName.isNull()) return false;
	return true;
}

bool printcapEntry::isSpoolName(){
 return !SpoolName.isEmpty();
}

bool printcapEntry::isSpoolDir(){
	return !SpoolDir.isEmpty();
}

bool printcapEntry::isFilterName(){
	return !FilterName.isEmpty();
}

bool printcapEntry::isLogFile(){
	return !LogFile.isEmpty();
}

bool printcapEntry::isAccountFile(){
	return !AccountFile.isEmpty();
}

bool printcapEntry::isPrinterPort(){
	return !PrinterPort.isEmpty();
}

bool printcapEntry::isRemoteMachine(){
	return !RemoteMachine.isEmpty();
}

bool printcapEntry::isRemotePrinterName(){
	return !RemotePrinterName.isEmpty();
}

bool printcapEntry::isOthers(){
	return !Others.isEmpty();
}


















