/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __DEVICE_H
#define __DEVICE_H

#include <kapp.h>

#include <qlist.h>
#include <qstring.h>

#include "resbaseconf.h"
#include "resource.h"


class Device
{
  public:
  
    enum bustype   { BusUnknown,
                     BusISA,
		     BusParallel,
		     BusPCI,
		     BusSerial,
		     BusUSB,
		     BusIDE,
		     BusSCSI };
 
    enum baseclass { BaseClassNone                  = 0xffff,
 
		     BaseClassPCIUnclassified       = 0x00,
                     BaseClassPCIStorage            = 0x01,
                     BaseClassPCINetwork            = 0x02,
                     BaseClassPCIDisplay            = 0x03,
                     BaseClassPCIMultimedia         = 0x04,
                     BaseClassPCIMemory	            = 0x05,
                     BaseClassPCIBridge	            = 0x06,
                     BaseClassPCICommunication      = 0x07,
                     BaseClassPCISystem	            = 0x08,
                     BaseClassPCIInput	            = 0x09,
                     BaseClassPCIDocking            = 0x0a,
                     BaseClassPCIProcessor          = 0x0b,
                     BaseClassPCISerial	            = 0x0c,
	
		     BaseClassMassStorage           = 0x80,
		     BaseClassMassStorageController = 0x81,
		     BaseClassPrinter               = 0x83,
		     BaseClassProcessor             = 0x84,
		     BaseClassWORM                  = 0x85,
		     BaseClassCDROM                 = 0x86,
		     BaseClassScanner               = 0x87,
		     BaseClassCommunication         = 0x88,
		     BaseClassEnclosure             = 0x89,
		     BaseClassSCSIController        = 0x8a,
		     BaseClassConnector             = 0x8b };
 
    enum devstate  { DeviceStateUnknown,
    		     DeviceStateReady }; 
 
    Device(baseclass bclass = BaseClassNone, const QString& name = "");	   
    
    virtual ~Device() {}

            void       addResource(Resource *);
            void       removeResource(Resource *);
            void       replaceResource(Resource *resnew, Resource *resold);
	
    virtual bustype    busType()	          const = 0;

    virtual ResourceBaseConfig  *baseConfig(int)        { return 0L; }
    virtual ResourceBaseConfig  *firstConfig()      	{ return 0L; }
    virtual ResourceBaseConfig  *nextConfig()       	{ return 0L; }
    virtual uint                numConfigs()      const { return 0;  }
    virtual int                 settingsBasedOn()	{ return -1; }
    
    virtual QString             deviceClassName()	{ return i18n("Unknown device type"); }
    virtual QString             deviceName()		{ return i18n("Unknown device");      }
    virtual devstate            deviceState()		{ return DeviceStateUnknown;	      }
    virtual QString             vendorName()		{ return i18n("Unknown vendor");      }
 
            QString             bigPixmapFile();
            baseclass           deviceBaseClass() const { return _baseclass;	   }
            QString             deviceBaseClassName();
            Resource            *firstResource()	{ return _reslist.first(); }
            Resource            *nextResource() 	{ return _reslist.next();  }
            int                 numResources()    const { return _reslist.count(); }
            QString             smallPixmapFile();
		   
  protected:
  
    QList<Resource>  _reslist;
    QString          _devname;
    baseclass        _baseclass;
};


#endif
