/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PROPDIALOG_H
#define __PROPDIALOG_H

#include <qtabdialog.h>

#include "device.h"
#include "propgentab.h"
#include "proprestab.h"
#include "propsettab.h"


class PropertiesDialog : public QTabDialog
{
  Q_OBJECT
  
  public:
  
    PropertiesDialog(Device *, QWidget *parent = 0L, const char *name = 0);
    ~PropertiesDialog() {}
    
  private:
  
    GeneralPropertiesTab   *_genproptab;
    ResourcePropertiesTab  *_resproptab;
    SettingsPropertiesTab  *_setproptab;

    Device  *_device;
};


#endif

