/**********************************************************************

	--- Dlgedit generated file ---

	File: KVidTune.cpp
	Last generated: Fri Nov 7 18:35:59 1997

 *********************************************************************/

/*#include <qbitmap.h>*/

#include "kvidtune.h"

#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

#define Inherited KVidTuneData

KVidTune::KVidTune
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	NotifyEnable = 1;
	Steps = 4;
	slider_steps->setValue(Steps);
	label_steps->setNum(Steps);

        KIconLoader *loader = kapp->getIconLoader();

	button_right->setPixmap(loader->loadIcon("kvidtune-right.xpm"));
	button_left->setPixmap(loader->loadIcon("kvidtune-left.xpm"));
	button_up->setPixmap(loader->loadIcon("kvidtune-up.xpm"));
	button_down->setPixmap(loader->loadIcon("kvidtune-down.xpm"));
	button_wider->setPixmap(loader->loadIcon("kvidtune-wider.xpm"));
	button_narrower->setPixmap(loader->loadIcon("kvidtune-narrower.xpm"));
	button_taller->setPixmap(loader->loadIcon("kvidtune-taller.xpm"));
	button_shorter->setPixmap(loader->loadIcon("kvidtune-shorter.xpm"));

        connect( button_right, SIGNAL(clicked()), SLOT(RightButton()) );
	connect( button_left, SIGNAL(clicked()), SLOT(LeftButton()) );
	connect( button_up, SIGNAL(clicked()), SLOT(UpButton()) );
	connect( button_down, SIGNAL(clicked()), SLOT(DownButton()) );
	connect( button_taller, SIGNAL(clicked()), SLOT(TallButton()) );
	connect( button_wider, SIGNAL(clicked()), SLOT(WideButton()) );
	connect( button_shorter, SIGNAL(clicked()), SLOT(ShorterButton()) );
	connect( button_narrower, SIGNAL(clicked()), SLOT(NarrowButton()) );

	connect( combobox_videomode, SIGNAL(activated(int)), SLOT(VideoModeCombo(int)) );
	connect( checkbox_auto, SIGNAL(toggled(bool)), SLOT(LifeCheckBox(bool)) );
	connect( slider_steps, SIGNAL(valueChanged(int)), SLOT(StepSlider(int)) );

	connect( button_modeline, SIGNAL(clicked()), SLOT(ModelineButton()) );
	connect( button_details, SIGNAL(clicked()), SLOT(DetailsButton()) );
	connect( button_undo, SIGNAL(clicked()), SLOT(UndoButton()) );
	connect( button_test, SIGNAL(clicked()), SLOT(TestButton()) );
	connect( button_restore, SIGNAL(clicked()), SLOT(RestoreButton()) );
//	connect( button_save, SIGNAL(clicked()), SLOT(SaveButton()) );

	connect(checkbox_interlace, SIGNAL(toggled(bool)), SLOT(Interlace(bool)) );
	connect(checkbox_doublescan, SIGNAL(toggled(bool)), SLOT(DoubleScan(bool)) );
	connect(checkbox_composite, SIGNAL(toggled(bool)), SLOT(Composite(bool)) );
	connect(checkbox_phsync, SIGNAL(toggled(bool)), SLOT(PHSync(bool)) );
	connect(checkbox_nhsync, SIGNAL(toggled(bool)), SLOT(NHSync(bool)) );
	connect(checkbox_pvsync, SIGNAL(toggled(bool)), SLOT(PVSync(bool)) );
	connect(checkbox_nvsync, SIGNAL(toggled(bool)), SLOT(NVSync(bool)) );
	connect(checkbox_pcsync, SIGNAL(toggled(bool)), SLOT(PCSync(bool)) );
	connect(checkbox_ncsync, SIGNAL(toggled(bool)), SLOT(NCSync(bool)) );
}


KVidTune::~KVidTune()
{
}

void KVidTune::VideoModeCombo(int index)
{
    emit VidVideoMode(index+1);
}

void KVidTune::SetLifeAdjust(bool state)
{
    checkbox_auto->setChecked(state);
    button_test->setEnabled(!state);
}

void KVidTune::SetVideoModeList(const QStrList *list)
{
    combobox_videomode->clear();
    combobox_videomode->insertStrList(list);
};

void KVidTune::SetVideoModeSelection(int index)
{
    combobox_videomode->setCurrentItem(index-1);
};

void KVidTune::SetValueBox(char *resolution, char *hrefresh, char *vrefresh)
{
    label_resinfo->setText(resolution);
    label_hrefresh->setText(hrefresh);
    label_vrefresh->setText(vrefresh);
}

void KVidTune::SetFlagCheckBoxes(bool interlace, bool doublescan, bool composite, 
                                 bool phsync, bool nhsync, bool pvsync, bool nvsync, 
				 bool pcsync, bool ncsync)
{
    --NotifyEnable;
    checkbox_interlace->setChecked(interlace);
    checkbox_doublescan->setChecked(doublescan);
    checkbox_composite->setChecked(composite);
    checkbox_phsync->setChecked(phsync);
    checkbox_nhsync->setChecked(nhsync);
    checkbox_pvsync->setChecked(pvsync);
    checkbox_nvsync->setChecked(nvsync);
    checkbox_pcsync->setChecked(pcsync);
    checkbox_ncsync->setChecked(ncsync);
    ++NotifyEnable;
}

void KVidTune::RightButton()
{
    emit VidMoveRight(Steps);
}

void KVidTune::LeftButton()
{
    emit VidMoveLeft(Steps);
}

void KVidTune::UpButton()
{
    emit VidMoveUp(Steps);
}

void KVidTune::DownButton()
{
    emit VidMoveDown(Steps);
}

void KVidTune::TallButton()
{
    emit VidSizeTaller(Steps);
}

void KVidTune::WideButton()
{
    emit VidSizeWider(Steps);
}

void KVidTune::ShorterButton()
{
    emit VidSizeShorter(Steps);
}

void KVidTune::NarrowButton()
{
    emit VidSizeNarrower(Steps);
}

void KVidTune::LifeCheckBox(bool state)
{
    button_test->setEnabled(!state);
    emit VidLifeAdjust(state);
}

void KVidTune::StepSlider(int value)
{
    Steps = value;
    label_steps->setNum(value);
}

void KVidTune::ModelineButton()
{
    emit VidActionModeline();
}

void KVidTune::DetailsButton()
{
    emit VidActionDetails();
}

void KVidTune::UndoButton()
{
    emit VidActionUndo();
}

void KVidTune::TestButton()
{
    emit VidActionTest();
}

void KVidTune::RestoreButton()
{
    emit VidActionRestore();
}

void KVidTune::SaveButton()
{
    emit VidActionSave();
}

void KVidTune::Interlace(bool state)
{
    if (NotifyEnable) emit VidInterlace(state);
}

void KVidTune::DoubleScan(bool state)
{
    if (NotifyEnable) emit VidDoubleScan(state);
}

void KVidTune::Composite(bool state)
{
    if (NotifyEnable) emit VidComposite(state);
}

void KVidTune::PHSync(bool state)
{
    if (NotifyEnable) emit VidPHSync(state);
}

void KVidTune::NHSync(bool state)
{
    if (NotifyEnable) emit VidNHSync(state);
}

void KVidTune::PVSync(bool state)
{
    if (NotifyEnable) emit VidPVSync(state);
}

void KVidTune::NVSync(bool state)
{
    if (NotifyEnable) emit VidNVSync(state);
}

void KVidTune::PCSync(bool state)
{
    if (NotifyEnable) emit VidPCSync(state);
}

void KVidTune::NCSync(bool state)
{
    if (NotifyEnable) emit VidNCSync(state);
}
