/**********************************************************************

	--- Qt Architect generated file ---

	File: dlgfilesavewizzardtopw.cpp
	Last generated: Thu Dec 25 22:27:58 1997

 *********************************************************************/

#include <config.h>

#include <stdio.h>
#include <stdlib.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_SYS_TIME_H
#include <sys/time.h> 
#endif

#if HAVE_SYS_STAT_H
#include <sys/stat.h> 
#endif

#include <utime.h> 
#include <kapp.h>

#include "dlgfilesavewizzardtopw.h"
#include "dlgfilesavewizzard0.h"
#include "dlgfilesavewizzard1.h"
#include "dlgfilesavewizzard2.h"
#include "dlgfilesavewizzard3.h"
#include "dlgfilesavewizzard4.h"

#define Inherited DlgFileSaveWizzardTopWData

DlgFileSaveWizzardTopW::DlgFileSaveWizzardTopW
(
	QWidget* parent,
	const char* name,
	XF86VidMode *vm,
	const QString    &fn,
	const QString    &wd
)
	:
	Inherited( parent, name )
{
	setCaption(klocale->translate("Configuration save wizzard"));
	frame_dock->move(10,10);

	inErrorState = FALSE;
	Step = -1;
	topDockWidget = NULL;
	messageText = NULL;

	vidMode = vm;
	fileNameFrom.setStr(fn);
	fileNameTo = fileNameFrom;
	//workingDirectory.setStr(wd);
	workingDirectory = wd; // swallow copy

	GotoStep(0);

	pushbutton_next->setFocus();

}

DlgFileSaveWizzardTopW::~DlgFileSaveWizzardTopW()
{
}

void DlgFileSaveWizzardTopW::resizeEvent ( QResizeEvent * )
{
  // workaround for layout manager ( I use a dummy qframe to resize different qwidgets)
  topDockWidget->resize(frame_dock->width(),frame_dock->height());
}

void DlgFileSaveWizzardTopW::GotoStep(int step)
{
  if ( Step == step || step < FirstStep || step > LastStep ) 
    return;

  if ( !inErrorState ) {
    switch ( Step ) {
      case 2: ((DlgFileSaveWizzard2*)topDockWidget)->ReadLabels(fileNameFrom,
                                                                workingDirectory);
              break;
      case 3: fileNameTo = NULL; // !! Here we unlink the reference to fileNameFrom !!
              ((DlgFileSaveWizzard3*)topDockWidget)->ReadLabels(fileNameTo,
                                                                workingDirectory);
              break;
    }
  }

  if ( step > Step ) {  // step forward
    if ( inErrorState ) {
      reject();
      return;  
    }
    switch ( Step ) {
      case 1: if ( ! Step1() ) { inErrorState = TRUE; }; break;
      case 2: if ( ! Step2() ) { inErrorState = TRUE; }; break;
      case 3: if ( ! Step3() ) { inErrorState = TRUE; }; break;
    }
  } else { // step backward
    inErrorState = FALSE;
  }

  Step = step;

  if ( topDockWidget ) {
    topDockWidget->close();
    delete topDockWidget;
  }

  if ( inErrorState ) {
    QLabel* l = new QLabel(this,"wizzard_err");
    l->setAlignment(289);
    l->setAutoResize(TRUE);
    l->setMargin( -1 );
    l->setText(klocale->translate("ERROR\n\n"
               "The last step failed. The following error message was given:\n\n")
               +messageText);
    topDockWidget = l;
  } else {
    switch ( Step ) {
      case 0: topDockWidget = new DlgFileSaveWizzard0(this,"wizzard_step0");
              break;
      case 1: {
              topDockWidget = new DlgFileSaveWizzard1(this,"wizzard_step1");
              QString mn,dn;
              mn.fill(0,256);
	      gethostname((char*)(const char*)mn,mn.size()-1);
	      dn.setStr(DisplayString(x11Display()));
              ((DlgFileSaveWizzard1*)topDockWidget)->FillLabels(mn,dn);
              break;
	      }
      case 2: topDockWidget = new DlgFileSaveWizzard2(this,"wizzard_step2");
              ((DlgFileSaveWizzard2*)topDockWidget)->FillLabels(fileNameFrom,
	                                                        workingDirectory);
              break;
      case 3: topDockWidget = new DlgFileSaveWizzard3(this,"wizzard_step3");
              ((DlgFileSaveWizzard3*)topDockWidget)->FillLabels(fileNameTo,
	                                                        workingDirectory);
              break;
      case 4: topDockWidget = new DlgFileSaveWizzard4(this,"wizzard_step4");
              ((DlgFileSaveWizzard4*)topDockWidget)->FillLabels(fileNameTo+"~");
              break;
    }
  }

  frame_dock->resize(topDockWidget->width(),topDockWidget->height());
  //topDockWidget->move(frame_dock->x(),frame_dock->y());
  topDockWidget->move(15,15);
  topDockWidget->show();

  //pushbutton_prev->setEnabled(Step>FirstStep);
  //pushbutton_next->setEnabled(Step<LastStep);
  pushbutton_prev->setText(Step>FirstStep?"<&<":klocale->translate("&Cancel"));
  pushbutton_next->setText(inErrorState?klocale->translate("&Cancel"):(Step<LastStep?"&>>":klocale->translate("&Close")));

  // there should be a better way than hardcoding some sizes
  resize( width(), 115 + topDockWidget->height() ); 
}

void DlgFileSaveWizzardTopW::Next()
{
  if ( Step == LastStep )
    accept();
  else
    GotoStep(Step+1);
}

void DlgFileSaveWizzardTopW::Previous()
{
  if ( Step == FirstStep )
    reject();
  else
    GotoStep(Step-1);
}

bool DlgFileSaveWizzardTopW::Step1()
{
  return TRUE;
}

bool DlgFileSaveWizzardTopW::Step2()
{
  XF86VidModeLine *modelines = NULL;
  unsigned        count;
  bool            b = TRUE;

  if ( !vidMode->GetAllModeLines(modelines,count) ) {
    messageText.setStr(klocale->translate("Failed to get modelines data."));
    return FALSE;
  }

  char *vendor = vidMode->MonitorVendor();
  char *model  = vidMode->MonitorModel();

  if ( !x86cfg.Load(fileNameFrom) || !x86cfg.SetModeLines(vendor,model,modelines,count) ) {
    messageText.setStr(x86cfg.LastErrorText());
    b = FALSE;
  }

  delete [] modelines;
  free(vendor);
  free(model);  

  return b;
}

bool DlgFileSaveWizzardTopW::Step3()
{
  QFile f(fileNameTo);
  QString backupfilename(fileNameTo+"~");

  // backup copy, care for hard links!
  if ( f.exists() ) {
    QFile bf(backupfilename);
    /* 
     * Readonly should be enough, but this way we get an error message ( writeonly by root)
     * before we make a backup - deleting old backup + confusing user
     */
    if ( !f.open(IO_ReadWrite) ) {
       messageText.setStr(klocale->translate("Configuration file cannot be accessed for reading and writing.\n"
                          "Check file permissons and existance."));
       return FALSE;
    }
    if ( !bf.open( IO_Truncate | IO_WriteOnly) ) {
       messageText.setStr(klocale->translate("Backup file cannot be created.\nCheck rights and filespace."));
       return FALSE;
    }
    /*
     * stupid copy 
     */
    int i;
    char buf[256];
    while ( ( i = f.readBlock( buf, sizeof(buf) ) ) > 0 ) {
      if ( bf.writeBlock( buf, i ) != i ) {
        messageText.setStr(klocale->translate("Backup file cannot be written.\nCheck disk space."));
	return FALSE;
      };
    }
    bf.close();
    f.close();
    /*
     * copy file permissions/time/owner etc...
     */
    struct stat st;
    struct utimbuf tb;
    if ( stat(fileNameTo, &st) == 0 ) {
      chmod(backupfilename,st.st_mode);
      chown(backupfilename,st.st_uid,st.st_gid);
      tb.actime = st.st_atime;
      tb.modtime = st.st_mtime;
      utime(backupfilename,&tb);
    }
  }

  if ( !x86cfg.Store(fileNameTo) ) {
    messageText.setStr(x86cfg.LastErrorText());
    return FALSE;
  }
  return TRUE;
}
