/*

    Copyright (C) 1997 Frithjof Brestrich
                       brestrich@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef __XF86VidMode_included__
#define __XF86VidMode_included__

#include <X11/Intrinsic.h>
/*
 * HOTE: This is a c++ workaround for older XFree86 distributions like 3.1.2
 *       The guys have fixed the problem in newer versions like 3.3.1
 */
#define private c_private 
#include <X11/extensions/xf86vmode.h>
#undef private

//
// take care not to overlay namespace with "X11/extensions/xf86vmode.h"
//

/* Mode flags -- ignore flags not in V_FLAG_MASK */
#define VM_FLAG_FLAG_MASK     0x1FF;
#define VM_FLAG_PHSYNC        0x001
#define VM_FLAG_NHSYNC        0x002
#define VM_FLAG_PVSYNC        0x004
#define VM_FLAG_NVSYNC        0x008
#define VM_FLAG_INTERLACE     0x010
#define VM_FLAG_DBLSCAN       0x020
#define VM_FLAG_CSYNC         0x040
#define VM_FLAG_PCSYNC        0x080
#define VM_FLAG_NCSYNC        0x100


class XF86VidModeLine;
class XF86VidMode;

struct XF86VidSyncRange {
    unsigned start, end;
};

class XF86VidModeLine
{
    friend XF86VidMode;

    XF86VidModeModeLine  ModeLine;
    int                  DotClock;
    char                 *Name;

public:

    XF86VidModeLine();
    XF86VidModeLine(XF86VidModeLine &templ);
    ~XF86VidModeLine();

    bool  Move(int dx, int dy);
    bool  Resize(int dx, int dy);
    bool  Interlace(bool on);
    bool  Doublescan(bool on);
    bool  Composite(bool on);
    bool  PHSync(bool on);
    bool  NHSync(bool on);
    bool  PVSync(bool on);
    bool  NVSync(bool on);
    bool  PCSync(bool on);
    bool  NCSync(bool on);

    XF86VidModeLine &operator=( XF86VidModeLine &right ) {
				Set(*right.Get(),right.GetDotClock()); 
				return *this; 
			      };

    XF86VidModeLine &operator=( XF86VidModeModeInfo &right ) {
				Set(right);
				return *this; 
			      };
    bool   SameValues(const XF86VidModeLine &ml);

    int    GetHorizontalResolution() { return ModeLine.hdisplay; };
    int    GetVerticalResolution()   { return ModeLine.vdisplay; };
    int    GetHorizontalSyncStart()  { return ModeLine.hsyncstart; };
    int    GetHorizontalSyncEnd()    { return ModeLine.hsyncend; };
    int    GetHorizontalSyncTotal()  { return ModeLine.htotal; };
    double GetHorizontalSyncClock()  { return (1000.0*(double)DotClock)/ModeLine.htotal; };
    int    GetVerticalSyncStart()    { return ModeLine.vsyncstart; };
    int    GetVerticalSyncEnd()      { return ModeLine.vsyncend; };
    int    GetVerticalSyncTotal()    { return ModeLine.vtotal; };
    double GetVerticalSyncClock();
    double GetPixelClock()           { return ((double)DotClock/1000); };
    int    GetDotClock()             { return DotClock; };
    int    GetFlags()                { return ModeLine.flags; };
    bool   IsInterlace();
    bool   IsDoublescan();
    bool   IsComposite();
    bool   IsPHSync();
    bool   IsNHSync();
    bool   IsPVSync();
    bool   IsNVSync();
    bool   IsPCSync();
    bool   IsNCSync();

    char*  GetModeline();

    void   SetName(const char* name);
    char*  GetName()                 { return Name?strdup(Name):NULL; };
    
protected:
    
    XF86VidModeModeLine* Get();
    void Set(XF86VidModeModeLine& ml, int dotclk, const char* name = NULL);
    void Set(XF86VidModeModeInfo& mi, const char* name = NULL);

private:

    void ClearData();
    
};

class XF86VidMode 
{
private:
    char                 *ErrorText;
    static int           (*XErrorFunc)(Display *, XErrorEvent *);
    static int           X11VMErrorBase;

protected:
    Display              *pDisplay;
    int                  Screen;

    static int           XErrorOccured;
    static int           XErrorCode;

    XF86VidModeMonitor   Monitor;
    unsigned             ModeCount;
    XF86VidModeLine      *ModeLines;
    unsigned             AktMode;
    int                  MajorVersion, MinorVersion;
    int                  EventBase, ErrorBase;

private:
    void  SetErrorText(char *txt);
    static int X11ErrorHandler(Display *dis,XErrorEvent *err);

public:

    XF86VidMode();
    virtual ~XF86VidMode();

    char  *LastErrorText();
    
    bool  ConnectDisplay(Display* display, int screen);
    bool  Disconnect();
    bool  RequestData();
    bool  LockModeSwitch(bool Locked);

    char* X11ProtocolVersion();
    char* X11Vendor();
    char* X11ReleaseVersion();
    char* XF86VidModeVersion();

    char* MonitorVendor() { return strdup(Monitor.vendor); };
    char* MonitorModel()  { return strdup(Monitor.model); };
    char* MonitorBandwidth();
    char* MonitorSyncRatesH();
    char* MonitorSyncRatesV();

    int   GetColorDepth();
			  
    int   GetModeCount()  { return ModeCount; };
    int   GetMode()       { return AktMode+1; };
    bool  SetMode(unsigned mode = 0);               // 0 = aktmode

    bool  GetModeLine(XF86VidModeLine &ml);
    bool  SetModeLine(XF86VidModeLine &ml);

    bool  GetAllModeLines(XF86VidModeLine *&mlsi, unsigned &count);   // unsorted
    bool  GetModeLineList(XF86VidModeLine *&mlsi, unsigned &count);   // sorted

protected:
    bool  GetMonitorData();
    bool  GetVideoModesData();

    void  SortModeLineList(XF86VidModeLine *&mls, unsigned count);
};
#endif //  __XF86VidMode_included__
