/***************************************************************************
                          dhlog.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include <dhlog.h>
#include "dhlogview.h"
#include "dhlogdoc.h"
#include "resource.h"


DHLogApp::DHLogApp()
{
	config=kapp->getConfig();
	
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initDocument();
  initView();
	
	readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
	disableCommand(ID_FILE_SAVE);
	disableCommand(ID_FILE_SAVE_AS);
	disableCommand(ID_FILE_PRINT);
	
	disableCommand(ID_EDIT_CUT);
	disableCommand(ID_EDIT_COPY);
	disableCommand(ID_EDIT_PASTE);
}

DHLogApp::~DHLogApp()
{

}

void DHLogApp::initKeyAccel()
{
	key_accel = new KAccel( this );
	
	// file_menu accelerators
	key_accel->connectItem( KAccel::New, this, SLOT( slotFileNew() ) );
	key_accel->connectItem( KAccel::Open, this, SLOT( slotFileOpen() ) );
	key_accel->connectItem( KAccel::Save, this, SLOT( slotFileSave() ) );
	key_accel->connectItem( KAccel::Close, this, SLOT( slotFileClose() ) );
	key_accel->connectItem( KAccel::Print, this, SLOT( slotFilePrint() ) );
	key_accel->connectItem( KAccel::Quit, this, SLOT( slotFileQuit() ) );
	
	// edit_menu accelerators
	key_accel->connectItem( KAccel::Cut, this, SLOT( slotEditCut() ) );
	key_accel->connectItem( KAccel::Copy, this, SLOT( slotEditCopy() ) );
	key_accel->connectItem( KAccel::Paste, this, SLOT( slotEditPaste() ) );
	key_accel->insertItem(i18n("Left"),"Left","Left");
	key_accel->insertItem(i18n("Right"),"Right","Right");
	key_accel->insertItem(i18n("Home"),"Home","Home");
	key_accel->insertItem(i18n("End"),"End","End");
	key_accel->connectItem( "Left",this,SLOT(slotEditPrev()));
	key_accel->connectItem("Right",this,SLOT(slotEditNext()));
	key_accel->connectItem("Home", this,SLOT(slotEditBeginning()));
	key_accel->connectItem("End",  this,SLOT(slotEditEnding()));
	
	// logging menu accelerators
	key_accel->insertItem("ALT+O","ALT O","ALT+O");
	key_accel->connectItem( "ALT O",this,SLOT( slotLoggingOnTime() ) );
	key_accel->connectItem( KAccel::Help, kapp, SLOT( appHelpActivated() ) );

			
	key_accel->changeMenuAccel(	file_menu, ID_FILE_NEW, KAccel::New );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_OPEN, KAccel::Open );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_SAVE, KAccel::Save );
	key_accel->changeMenuAccel( file_menu, ID_FILE_CLOSE, KAccel::Close );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_PRINT, KAccel::Print );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_QUIT, KAccel::Quit );

	key_accel->changeMenuAccel(	edit_menu, ID_EDIT_CUT, KAccel::Cut );
  	key_accel->changeMenuAccel(	edit_menu, ID_EDIT_COPY, KAccel::Copy );
  	key_accel->changeMenuAccel(	edit_menu, ID_EDIT_PASTE, KAccel::Paste );
  	key_accel->changeMenuAccel(   edit_menu, ID_EDIT_QSOPREV,"Left");
  	key_accel->changeMenuAccel(   edit_menu, ID_EDIT_QSONEXT,"Right");
  	key_accel->changeMenuAccel(   edit_menu, ID_EDIT_BEGINNING,"Home");
  	key_accel->changeMenuAccel(	edit_menu, ID_EDIT_ENDING,"End");
  	
	key_accel->changeMenuAccel( logging_menu, ID_LOGGING_ONTIME, "ALT O");

	key_accel->readSettings();	
}

void DHLogApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

	recent_files_menu = new QPopupMenu();
  connect( recent_files_menu, SIGNAL(activated(int)), SLOT(slotFileOpenRecent(int)) );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/dhlogapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
	file_menu->insertItem(i18n("Open &recent"), recent_files_menu, ID_FILE_OPEN_RECENT );

  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("Sort &Log"), ID_FILE_SORT);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT );
  edit_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
  edit_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("&Delete Qso"),ID_EDIT_DELETE);
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("&First Qso"),ID_EDIT_BEGINNING);
  edit_menu->insertItem(i18n("&Last Qso"),ID_EDIT_ENDING);
  edit_menu->insertItem(Icon("back.xpm"),i18n("&Prev Qso"),ID_EDIT_QSOPREV);
  edit_menu->insertItem(Icon("forward.xpm"),i18n("&Next Qso"),ID_EDIT_QSONEXT);
  edit_menu->insertItem(i18n("&Jump Qso No."),ID_EDIT_JUMP);
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("Edit &Qso"),ID_EDIT_QSO);
  edit_menu->insertItem(i18n("Edit &Call"),ID_EDIT_CALL);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry logging_menu
  logging_menu = new QPopupMenu();
  logging_menu->insertItem(i18n("&New Qso"), ID_LOGGING_NEW);
	logging_menu->insertItem(Icon("ontimelog.xpm"),i18n("&On-Time Log"), ID_LOGGING_ONTIME);

  ///////////////////////////////////////////////////////////////////
  qsl_menu = new QPopupMenu();
  qsl_menu->insertItem(i18n("Qsl &in"), ID_QSL_IN);
  qsl_menu->insertItem(i18n("Qsl &out"), ID_QSL_OUT);
  qsl_menu->insertItem(i18n("&Mark Qsls out"), ID_QSL_SETOUT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n\n(c)1999 by DL6DH\nHenning Folger <hf@holgu.de>";

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertItem(i18n("&Logging"), logging_menu);
  menuBar()->insertItem(i18n("&Qsl"), qsl_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(edit_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(edit_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(logging_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(logging_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(qsl_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(qsl_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

}

void DHLogApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New Log") );
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open Log") );
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save Log") );
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print Log") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut Qso") );
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy Qso") );
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste Qso") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("back.xpm"), ID_EDIT_QSOPREV, true, i18n("One Qso back") );
  toolBar()->insertButton(Icon("forward.xpm"), ID_EDIT_QSONEXT, true, i18n("Next Qso") );
  toolBar()->insertButton(Icon("ontimelog.xpm"),ID_LOGGING_ONTIME,true,i18n("OnTime Log") );
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void DHLogApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
	// TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG );
}

void DHLogApp::initDocument()
{
  doc = new DHLogDoc(this);
  doc->newDocument();
  doc->setConfig(config);
}

void DHLogApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new DHLogView(this);
  doc->addView(view);
  setView(view);	
  setCaption(kapp->appName()+": "+doc->getTitle());
	view->UpdateView();
	slotEnableMenuEntries();
  connect(view,SIGNAL(updEnableMenu()), this, SLOT(slotEnableMenuEntries()));
}

void DHLogApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void DHLogApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

void DHLogApp::addRecentFile(const char* file)
{
  if(recent_files.find(file) == -1){
    if( recent_files.count() < 5)
      recent_files.insert(0,file);
    else{
      recent_files.remove(4);
      recent_files.insert(0,file);
    }
    recent_files_menu->clear();
    for ( int i =0 ; i < (int)recent_files.count(); i++){
      recent_files_menu->insertItem(recent_files.at(i));
    }
	}
}

void DHLogApp::openDocumentFile(const char* _cmdl)
{
  slotStatusMsg(i18n("Opening file..."));
	doc->openDocument(_cmdl);
   setCaption(kapp->appName()+": "+doc->getTitle());
  slotStatusMsg(i18n("Ready."));
  slotEnableMenuEntries();
}


DHLogDoc* DHLogApp::getDocument() const
{
	return doc;
}

void DHLogApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
	config->writeEntry("Recent Files", recent_files);
}


void DHLogApp::readOptions()
{
	
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
	if(!bViewToolbar)
		enableToolBar(KToolBar::Hide);
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
	if(!bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);
	
	// bar position settings
	KMenuBar::menuPosition menu_bar_pos;
	menu_bar_pos=(KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);
	
  // initialize the recent file list
	recent_files.setAutoDelete(TRUE);
	config->readListEntry("Recent Files",recent_files);
	
	uint i;
	for ( i =0 ; i < recent_files.count(); i++){
    recent_files_menu->insertItem(recent_files.at(i));
  }

  QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
		resize(size);
}

void DHLogApp::saveProperties(KConfig* sconfig)
{
	if( doc->log->anzQso() <= 0){
		return;
	}
	else{
		QString filename=doc->getPathName();
		if(doc->getTitle() == i18n("Untitled")) filename+= "Untitled";

    	sconfig->writeEntry("filename",filename);
    	sconfig->writeEntry("modified",doc->isModified());
    	
    	const char* tempname = kapp->tempSaveName(filename);
		doc->saveDocument(tempname);
	}
}


void DHLogApp::readProperties(KConfig* sconfig)
{
	QString filename = sconfig->readEntry("filename","");
	bool modified = sconfig->readBoolEntry("modified",false);
	
	bool b_canRecover;
	QString tempname = kapp->checkRecoverFile(filename,b_canRecover);
  	if(b_canRecover){
   			doc->openDocument(tempname);
   			doc->setModified(modified);
   			QFileInfo info(filename);
   			doc->pathName(info.absFilePath());
   			doc->title(info.fileName());
   			QFile::remove(tempname);
		}
 	
 	else if(!filename.isEmpty()){
		doc->openDocument(filename);
	}
  setCaption(kapp->appName()+": "+doc->getTitle());
}		

bool DHLogApp::queryClose()
{
	return doc->saveModified();
}

bool DHLogApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void DHLogApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Log window..."));
	
	DHLogApp* new_window= new DHLogApp();
	new_window->show();
	
  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new Logbook..."));
	
	if(!doc->saveModified())
		return;
	
	doc->newDocument();		
	setCaption(kapp->appName()+": "+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening Log..."));
	
	if(!doc->saveModified())
		return;
	
	QString fileToOpen=KFileDialog::getOpenFileName(QDir::homeDirPath(),
		 "*.dhl DHLog-Files\n*.* all Files", this, i18n("Open Log..."));
	if(!fileToOpen.isEmpty()){
		doc->openDocument(fileToOpen);
		setCaption(kapp->appName()+": "+doc->getTitle());
		addRecentFile(fileToOpen);
	}

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileOpenRecent(int id_)
{
  slotStatusMsg(i18n("Opening Log..."));
	
	if(!doc->saveModified())
		return;

  doc->openDocument(recent_files.at(id_));
	setCaption(kapp->appName()+": "+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving Log..."));
	if(doc->getTitle() == i18n("Untitled"))
		slotFileSaveAs();
	else
		doc->saveDocument(doc->getPathName());

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving Log under new filename..."));

	QString newName=KFileDialog::getSaveFileName(QDir::currentDirPath(), "*.dhl DHLog-Files", this, i18n("Save As..."));
	
	if(!newName.isEmpty()){
		QFileInfo saveAsInfo(newName);
		doc->title(saveAsInfo.fileName());
		doc->pathName(saveAsInfo.absFilePath());
		if(strlen(saveAsInfo.extension()) == 0)
			newName+=".dhl";
		doc->saveDocument(newName);
		addRecentFile(newName);
		setCaption(kapp->appName()+": "+doc->getTitle());
	}

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing Log..."));
	
	close();
}

void DHLogApp::slotFileSort()
{
	slotStatusMsg(i18n("Sorting Logbook..."));
	doc->sortLog();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)){
			view->print(&printer);
	}

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotFileQuit()
{
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KTMainWindow* w;
	if(memberList){
		for(w=memberList->first(); w; w=memberList->first()){
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
				break;
		}
	}	
}

void DHLogApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to Clipboard..."));

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting Clipboard contents..."));

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditDelete()
{
	slotStatusMsg(i18n("Deleting current Qso..."));
	doc->editDeleteQso();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditBeginning()
{
	slotStatusMsg(i18n("Jumping to the beginning of the log..."));
	doc->editBeginning();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditEnding()
{
	slotStatusMsg(i18n("Jumping to the end of the log..."));
	doc->editEnding();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditPrev()
{
	slotStatusMsg(i18n("Jumping one Qso back...."));
	doc->editPrev();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditNext()
{
	slotStatusMsg(i18n("Jumping to next Qso..."));
	doc->editNext();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditJump()
{
	slotStatusMsg(i18n("Jumping to Qso No..."));
	doc->editJump();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditQso()
{
	slotStatusMsg(i18n("Editing actual Qso datas..."));	
	doc->editQso();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotEditCall()
{
	slotStatusMsg(i18n("Editing actual Call datas..."));
	doc->editCall();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotLoggingNew()
{
	slotStatusMsg(i18n("Logging new Qso..."));
	doc->loggingNew();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotLoggingOnTime()
{
	slotStatusMsg(i18n("Logging Qso on time..."));
	doc->loggingOnTime();
	slotStatusMsg(i18n("Ready."));
}
	
void DHLogApp::slotQslIn()
{
	slotStatusMsg(i18n("Handle incomming qsl cards..."));
	doc->qslIn();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotQslOut()
{
	slotStatusMsg(i18n("Listing outgoing qsl cards..."));
	doc->qslOut();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotQslSetOut()
{
	slotStatusMsg(i18n("Mark Qsls that qsl cards are out..."));
	doc->qslSetOut();
	slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
	if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
	  view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
		
  enableToolBar();

  slotStatusMsg(i18n("Ready."));
}

void DHLogApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
	  view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);

  enableStatusBar();

  slotStatusMsg(i18n("Ready."));
}


void DHLogApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void DHLogApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void DHLogApp::commandCallback(int id_){
  switch (id_){
    case ID_FILE_NEW_WINDOW:
    	slotFileNewWindow();
    	break;
    case ID_FILE_NEW:
    	slotFileNew();
    	break;
    case ID_FILE_OPEN:
    	slotFileOpen();
    	break;
    case ID_FILE_SAVE:
    	slotFileSave();
    	break;
    case ID_FILE_SAVE_AS:
    	slotFileSaveAs();
    	break;
    case ID_FILE_CLOSE:
    	slotFileClose();
    	break;
    case ID_FILE_SORT:
    	slotFileSort();
    	break;
    case ID_FILE_PRINT:
    	slotFilePrint();
    	break;
    case ID_FILE_QUIT:
    	slotFileQuit();
    	break;

    case ID_EDIT_CUT:
    	slotEditCut();
    	break;
    case ID_EDIT_COPY:
    	slotEditCopy();
    	break;
    case ID_EDIT_PASTE:
    	slotEditPaste();
    	break;
    case ID_EDIT_DELETE:
    	slotEditDelete();
    	break;
    case ID_EDIT_BEGINNING:
    	slotEditBeginning();
    	break;
    case ID_EDIT_ENDING:
    	slotEditEnding();
    	break;
    case ID_EDIT_QSOPREV:
    	slotEditPrev();
    	break;
    case ID_EDIT_QSONEXT:
    	slotEditNext();
    	break;
    case ID_EDIT_JUMP:
    	slotEditJump();
    	break;
    case ID_EDIT_QSO:
    	slotEditQso();
    	break;
    case ID_EDIT_CALL:
    	slotEditCall();
    	break;

    case ID_LOGGING_NEW:
    	slotLoggingNew();
    	break;
    case ID_LOGGING_ONTIME:
			slotLoggingOnTime();
			break;
		   	
    case ID_QSL_IN:
    	slotQslIn();
    	break;
    case ID_QSL_OUT:
    	slotQslOut();
    	break;
    case ID_QSL_SETOUT:
    	slotQslSetOut();
    	break;
    	
    case ID_VIEW_TOOLBAR:
    	slotViewToolBar();
    	break;
    case ID_VIEW_STATUSBAR:
    	slotViewStatusBar();
    	break;
    default:
    	break;
  }
//   wird direkt ber ein Signal emitiert...
//  slotEnableMenuEntries();
}

void DHLogApp::slotEnableMenuEntries()
{
	LogBook *log;
	bool  ic;
	
	log = doc->log;
	
	if(!log)
	{
		KMsgBox::message(NULL,"slotEnableMenuEntries","log == NULL");
		return;
	}
	if(log->anzQso() > 0)
		ic = true;
	else
	 	ic = false;
	
	if( ic )
	{
		enableCommand(ID_FILE_SAVE);
		enableCommand(ID_FILE_SAVE_AS);
		enableCommand(ID_FILE_SORT);
		//enableCommand(ID_FILE_PRINT);
		
		//enableCommand(ID_EDIT_COPY);
		//enableCommand(ID_EDIT_CUT);
		//enableCommand(ID_EDIT_PASTE);
		enableCommand(ID_EDIT_DELETE);
		if(log->aktQso() > 1)
		{
			enableCommand(ID_EDIT_BEGINNING);
			enableCommand(ID_EDIT_QSOPREV);
		}
		else
		{
			disableCommand(ID_EDIT_BEGINNING);
			disableCommand(ID_EDIT_QSOPREV);
		}
		if(log->aktQso() < log->anzQso())
		{
			enableCommand(ID_EDIT_ENDING);
			enableCommand(ID_EDIT_QSONEXT);
		}
		else
		{
			disableCommand(ID_EDIT_ENDING);
			disableCommand(ID_EDIT_QSONEXT);
		}
		enableCommand(ID_EDIT_JUMP);
		enableCommand(ID_EDIT_QSO);
		enableCommand(ID_EDIT_CALL);
		
		enableCommand(ID_LOGGING_NEW);
		enableCommand(ID_LOGGING_ONTIME);
		
		enableCommand(ID_QSL_IN);
		enableCommand(ID_QSL_OUT);
		enableCommand(ID_QSL_SETOUT);
	}
	else
	{
		disableCommand(ID_FILE_SAVE);
		disableCommand(ID_FILE_SAVE_AS);
		disableCommand(ID_FILE_SORT);
		//disableCommand(ID_FILE_PRINT);
		
		disableCommand(ID_EDIT_COPY);
		disableCommand(ID_EDIT_CUT);
		disableCommand(ID_EDIT_PASTE);
		disableCommand(ID_EDIT_DELETE);
		disableCommand(ID_EDIT_BEGINNING);
		disableCommand(ID_EDIT_ENDING);
		disableCommand(ID_EDIT_QSOPREV);
		disableCommand(ID_EDIT_QSONEXT);
		disableCommand(ID_EDIT_JUMP);
		disableCommand(ID_EDIT_QSO);
		disableCommand(ID_EDIT_CALL);
		
		//disableCommand(ID_LOGGING_NEW);
		//disableCommand(ID_LOGGING_ONTIME);
		
		//disableCommand(ID_QSL_IN); //Karten koennen ja immer kommen ;-)
		disableCommand(ID_QSL_OUT);
		disableCommand(ID_QSL_SETOUT);
	} 	
	
	
};


void DHLogApp::statusCallback(int id_){
  switch (id_){
    case ID_FILE_NEW_WINDOW:
    	slotStatusHelpMsg(i18n("Opens a new log window"));
    	break;
    case ID_FILE_NEW:
 	  	slotStatusHelpMsg(i18n("Creates a new logbook"));
 	  	break;
    case ID_FILE_OPEN:
 	  	slotStatusHelpMsg(i18n("Opens an existing logbook"));
 	  	break;
    case ID_FILE_OPEN_RECENT:
 	  	slotStatusHelpMsg(i18n("Opens a recently used log"));
 	  	break;
    case ID_FILE_SAVE:
 	  	slotStatusHelpMsg(i18n("Save the actual logbook"));
 	  	break;
    case ID_FILE_SAVE_AS:
 	  	slotStatusHelpMsg(i18n("Save the logbook as..."));
 	  	break;
    case ID_FILE_CLOSE:
    	slotStatusHelpMsg(i18n("Closes the actual log"));
    	break;
    case ID_FILE_SORT:
    	slotStatusHelpMsg(i18n("Sorting actual logbook"));
    	break;
    case ID_FILE_PRINT:
    	slotStatusHelpMsg(i18n("Prints the current log"));
    	break;
    case ID_FILE_QUIT:
    	slotStatusHelpMsg(i18n("Exits "+ kapp->appName()));
    	break;

    case ID_EDIT_CUT:
    	slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
    	break;
    case ID_EDIT_COPY:
    	slotStatusHelpMsg(i18n("Copys the selected section to the clipboard"));
    	break;
    case ID_EDIT_PASTE:
    	slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
    	break;
    case ID_EDIT_DELETE:
    	slotStatusHelpMsg(i18n("Delete the actual Qso"));
    	break;
    case ID_EDIT_BEGINNING:
    	slotStatusHelpMsg(i18n("Jumps to the first Qso in the Log"));
    	break;
    case ID_EDIT_ENDING:
    	slotStatusHelpMsg(i18n("Jumps to the last Qso in the Log"));
    	break;
    case ID_EDIT_QSOPREV:
    	slotStatusHelpMsg(i18n("Goes to the previus Qso"));
    	break;
    case ID_EDIT_QSONEXT:
    	slotStatusHelpMsg(i18n("Goes to the next Qso"));
    	break;
    case ID_EDIT_JUMP:
    	slotStatusHelpMsg(i18n("Jumps to a specified Qso No"));
    	break;
    case ID_EDIT_QSO:
    	slotStatusHelpMsg(i18n("Edits the actual Qso"));
    	break;
    case ID_EDIT_CALL:
    	slotStatusHelpMsg(i18n("Edits the calldatas of the actual Qso"));
      break;

    case ID_LOGGING_NEW:
    	slotStatusHelpMsg(i18n("Logging a new Qso"));
    	break;
		case ID_LOGGING_ONTIME:
			slotStatusHelpMsg(i18n("Logging a Qso ontime"));
			break;
    	
    case ID_QSL_IN:
    	slotStatusHelpMsg(i18n("Handle incomming Qsls"));
    	break;
    case ID_QSL_OUT:
    	slotStatusHelpMsg(i18n("Lists outgoing Qsls"));
    	break;
    case ID_QSL_SETOUT:
    	slotStatusHelpMsg(i18n("Mark Qsos that Qsls are out"));
    	break;

    case ID_VIEW_TOOLBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
    	break;
    case ID_VIEW_STATUSBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));
    	break;
		default:
			break;
  }
}












































































