/***************************************************************************
                          jumpqsodlg.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Jul 14 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "jumpqsodlg.h"
#include "dhlog.h"

JumpQsoDlg::JumpQsoDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	setCaption(i18n("Jump to Qso"));
	qsoNrLine->setFocus();
	qsoNrLine->setValidChars("1234567890");
	qsoNrLine->setMaxLength(10);
	
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotOk()));
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(qsoNrLine,SIGNAL(returnPressed()),this,SLOT(slotOk()));
}

JumpQsoDlg::~JumpQsoDlg(){
}

void JumpQsoDlg::setMaxQso(long nr)
{
	maxqso = nr;
};

//
// Signale abhandeln
//...................

void JumpQsoDlg::slotOk()
{
	long nr;
	
	nr = atol(qsoNrLine->text());
	if(nr <= 0)
	{
		KMsgBox::message(this,i18n("Jump to Qso"),i18n("Illegal value entered.\nUse value between 1 and max Qsos."));
		qsoNrLine->setFocus();
		return;
	}
	if(nr > maxqso)
	{
		KMsgBox::message(this,i18n("Jump to Qso"),i18n("Value grater than existing Qsos."));
		qsoNrLine->setFocus();
		return;
	}
	done(nr);
}

