/***************************************************************************
                          logfunc.h  -  description                              
                             -------------------                                         
    begin                : Tue May 18 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#ifndef __LOGFUNC_H
#define __LOGFUNC_H

#define MAXFILENAMELENGTH 260
#define BYTE unsigned char

//
// Infowerte
//-----------

#define INFO_QSLEIN 1
#define INFO_QSLAUS 2
#define INFO_QSLNOACTIVITY 4
#define INFO_QSOSPERREN 32
#define INFO_QSLDIREKT 64
#define INFO_MAX (INFO_QSLEIN+INFO_QSLAUS+INFO_QSLNOACTIVITY+INFO_QSOSPERREN+INFO_QSLDIREKT)

#define CALLPOS_NON 0
#define CALLPOS_CALL 1
#define CALLPOS_NAME 2
#define CALLPOS_QTH 3
#define CALLPOS_DOK 4
#define CALLPOS_LOCATOT 5

//
// Band- und Modedaten
//---------------------
#define BAND_ANZAHL 17
#define MODE_ANZAHL 19

//
// Logstrukturen
//---------------
#define VERSION_V100 1  // WinLog/2 OS/2
#define VERSION_V101 2  // WinLog/2 OS/2
#define VERSION_V102 3  // WinLog/2 OS/2
#define VERSION_V103 4  // WinLog/2 OS/2
#define VERSION_V200 5  // DHLog Win32
#define VERSION_V201 6 	// DHLog Linux & Win32

//
// Datumausgabeformate
//---------------------
#define DTAUS_NON 	1	// ttmmjj
#define DTAUS_SHORT	2	// tt.mm.jj
#define DTAUS_LONG 	3	// tt.mm.jjjj
#define DTAUS_DETAIL	4	// tt.mmm.jjjj

//
// QslAus Werte
//--------------
#define QSLOUT_NON 0
#define QSLOUT_ALL 1
#define QSLOUT_BURO 2
#define QSLOUT_DIREKT 3

//
// QslIn Werte
//-------------
#define QSLIN_OK 1
#define QSLIN_CANCEL 0
#define QSLIN_NEW 2

//
// CallCheck Werte
//-----------------
#define CALLCHECK_OK 0
#define CALLCHECK_NAME 1
#define CALLCHECK_QTH 2
#define CALLCHECK_DOK 3
#define CALLCHECK_LOC 4



//
// Datei-Infoblock
//-----------------
typedef struct {
	char testname[12];		// sollte DH-LOG als Kennung enthalten, nur Win32
	int  dateiversion;
	long anz_qso;
	long anz_call;
	char dummy1[80];			// war mal belegt, fuer OS/2
	long anz_bemerkung;
	long max_call;				// eigentlich noch frei, war fuer OS/2
	long bemnr;					// Nummer letzte Bemerkung
	char checksumme;			// erkennt Log als intakt oder defekt
} TDInfoBlock;



#endif






