/***************************************************************************
                          loglabel.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Apr 11 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "loglabel.h"
#include "dhlog.h"

LogLabel::LogLabel(QWidget *parent)
	:QLabel(parent)
{	
	setAlignment(AlignCenter);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setLineWidth(2);
	setBackgroundColor(QColor(255,255,255));
}

//
// LogListView
//-------------

LogListView::LogListView(QWidget *parent)
	:QListView(parent){
	

}

LogListView::~LogListView(){
}

void LogListView::createQslOutView()
{
	setAllColumnsShowFocus(true);
	setSorting(-1);
	addColumn(i18n(" Call "));
	addColumn(i18n(" Date "));
	addColumn(i18n(" UTC "));
	addColumn(i18n(" Band "));
	addColumn(i18n(" Mode "));
	addColumn(i18n(" RST "));
	addColumn(i18n(" Qsl Info "));
	addColumn(i18n(" Via "));
}

void LogListView::createQslInView()
{
	setAllColumnsShowFocus(true);
	setSorting(-1);
	setEnabled(true);
	addColumn(i18n(" Date "));
	addColumn(i18n(" UTC "));;
	addColumn(i18n("  Call  "));
	addColumn(i18n(" Band "));
	addColumn(i18n(" Mode "));
	addColumn(i18n(" QSL "));
}

void LogListView::createQsoEditView()
{
	setAllColumnsShowFocus(true);
	setSorting(-1);
	setEnabled(false);
	addColumn(i18n(" Call "));
	addColumn(i18n(" Date "));
	addColumn(i18n(" UTC "));
	addColumn(i18n(" Band "));
	addColumn(i18n(" Mode "));
	addColumn(i18n(" Qsl Info "));
}

void LogListView::addItemPointer(QListViewItem *item)
{
	itemList.append(item);
}

void LogListView::keyPressEvent(QKeyEvent *e)
{
	int key;
	
	key = e->key();
	if(itemList.isEmpty()) e->ignore();
	
	switch(key)
	{
		case Key_Up:
			itemList.findRef(currentItem());
			if(itemList.prev())
				setSelected(itemList.current(),true);
		   break;
			
		case Key_Down:
			itemList.findRef(currentItem());
			if(itemList.next())
				setSelected(itemList.current(),true);
			break;
			
		default:
			e->ignore();
	}
}











