/***************************************************************************
                          qso.h  -  description                              
                             -------------------                                         
    begin                : Fri Jun 4 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QSO_H
#define QSO_H

#include "stdio.h"
#include <kconfig.h>


#define QSO_CALL_LEN 15
#define QSO_VIACALL_LEN 15
#define QSO_RST_LEN 8

/**Funktionen zum Qso-Handling
  *@author Henning Folger
  */

#define ANZ_BAND 18
#define ANZ_MODE 20

class CBand {
public:
	CBand();
	int anzBand();
	char* band(int wert);
	
private:
	
};

class CMode {
public:
	CMode();
	int anzMode();
	char* mode(int wert);
	char* rst(int wert);
	
private:
	
};

class CDatum {
public:
	CDatum();
	CDatum(CDatum& old);
	
	bool insert(const char *wert);
	char *get(int datumformat);
	int getRaw();
	void create(int d,int m, int y);
	bool Load(FILE *fh);
	bool Save(FILE *fh);
   bool kuerzen(const char *dat,int *tag,int *mon, int *year);
private:
	int datum;
	char help[15];
};

class CUtc {
public:
	CUtc();
	CUtc(CUtc& old);
	
	bool insert(const char *wert);
	void create(int h,int m);
	char *get(bool trennzeichen=true);
	int getRaw();
	bool Load(FILE *fh);
	bool Save(FILE *fh);
private:
	int utc;
	char help[13];
};


	
	
class CQso {
private:
	
public:
	CQso();        											// legt ein leeres Qso an
	CQso(FILE *fh);                						// liest ein neues Qso aus dem File fh
	~CQso();
	
	char *GetCall(bool normal = true,char *out = NULL );					// normal -> ungekuertzt
	char *GetViaCall(void);
	char *GetRstEin(void);
	char *GetRstAus(void);
	int GetMode(void);	
	int GetBand(void);
	bool GetQslEin(void);
	bool GetQslAus(void);
	bool GetQslActivity(void);
	bool GetQslDirekt(void);
	
	bool SetCall(const char* str);
	bool SetViaCall(const char* str);
	bool SetRstEin(const char* str);
	bool SetRstAus(const char* str);
	bool SetMode(const int nr);
	bool SetBand(const int nr);
	void SetQslEin(bool ic = true);
	void SetQslAus(bool ic = true);
	void SetQslActivity(bool ic = true);
	void SetQslDirekt(bool ic = true);
	
	bool IsVia(void);
	
	bool LoadQso(FILE *fh);
	bool SaveQso(FILE *fh);
   void CallKuerzen(char *ziel,const char *call);
	
	CDatum datum;
	CUtc utc,endutc;
	
private:
	char call[QSO_CALL_LEN];
	char viacall[QSO_VIACALL_LEN];
	char band,mode;
	char rstein[QSO_RST_LEN],rstaus[QSO_RST_LEN];
	int info,dxcc,bemerkung;
};

class CCall {
public:
	CCall();
	CCall(FILE *fh);
	
   void GetCall(char *str);
   char *GetRawCall(void);
   char *GetName(void);
   char *GetQth(void);
   char *GetDok(void);
   char *GetLocator(void);

   void SetCall(const char *str);
   void SetRawCall(const char *str);
   void SetName(const char *str);
   void SetQth(const char *str);
   void SetDok(const char *str);
   void SetLocator(const char *str);

   int dataComplete(KConfig *config);

   bool LoadCall(FILE *fh);
   bool SaveCall(FILE *fh);

private:
	void reverse(char *s);
	char call[15];
	char name[21],qth[21],dok[7];
	char locator[7];
	int datum;								// noch alt, wird bald rausgenommen
	char valid;								// noch alt, wird bald rausgenommen
};

#endif



































