/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/status.h,v 1.5 1999/03/06 18:01:55 jonny Exp $

*/
#ifndef _FAX_STATUS_WIDGET_H
#define _FAX_STATUS_WIDGET_H


#include <kfm.h>
#include <kapp.h>
#include <qtabdlg.h>
#include <kspinbox.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <kprocess.h>
#include <ktablistbox.h>
#include "netcom.h"

class KHylaFaxStatus : public QDialog {
  Q_OBJECT

public:
	KHylaFaxStatus (KConfig *config, NetCom *netcom, QWidget * parent=0, const char * name=0);
	~KHylaFaxStatus();

protected:
	virtual void closeEvent ( QCloseEvent *);
	
private:
 KShellProcess *proc;
 KConfig *config;
 //QMultiLineEdit *listbox;
 KTabListBox *listbox;
 QString *output;
 NetCom *netcom;

 void getStatus();
 void processLine(const char *line);

public slots:
 void selected(int index, int col);
 void ReadStdout(KProcess *, char *buffer, int buflen);
 void Exited (KProcess *proc);
};

#endif _FAX_STATUS_WIDGET_H

















