/*
    File: ringbuffer.h
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    Here, we have a very simple ringbuffer-class!

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef RINGBUFFER_H
#define RINGBUFFER_H



class Ringbuffer {

public:

  // constructor
  Ringbuffer(int size,bool clear=true);

  // destructor
  ~Ringbuffer();

  // store new value
  void push(float value);
  
  // get an item from the buffer.
  // positiv values go back in time
  float get(int item=0);

private:

  int size;
  float* buffer;
  int run;

};



#endif
