/***************************************************************************
                          bibletime.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 15:34:26 CEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/bibletime.h,v 1.7 1999/11/25 17:58:20 jockel Exp $ */
/* $Revision: 1.7 $ */

#ifndef BIBLETIME_H
#define BIBLETIME_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kapp.h>
#include <ktmainwindow.h>
#include <kmsgbox.h>
#include <klined.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kquickhelp.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <htmlview.h>

//Qt includes
#include <qcheckbox.h>
#include <qclipboard.h>
#include <qdir.h>
#include <qlabel.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlist.h>

//own includes
#include "kwrite/kwview.h"
#include "resource.h"
#include "cknewaccel.h"
#include "printing/bibletimeprinter.h"

#include "structdef.h"

// forward declaration of the BibleTime classes
class BibleTimeDoc;
class BibleTimeView;


/** this structure stores info about one specific key
	*	and the module it comes from
	*/
struct HistoryKey
{
	QString	key;
	QString	module;
};


typedef QList<HistoryKey> HistoryList;


/**
  * The base class for BibleTime application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of BibleTimeView creates your center view, which is connected
  * to the window's Doc object.
  * BibleTimeApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
	*
	* @see KTMainWindow
	* @see KApplication
	* @see KConfig
	* @see CKNewAccel
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
  */
class BibleTimeApp : public KTMainWindow
{
  Q_OBJECT
  friend class BibleTimeView;

public:
  /** This is used to show the selection in the searchscope dialog
  	*/
	enum SearchScope 		{ NoScope, LastSearch, Bounds	};

  /** This is used to so show the selection of the searchdialog
  	*/
	enum SearchType 		{ MultiWord, ExactPhrase, RegEx	};

  /** construtor of BibleTimeApp, calls all init functions to create the application.
    * @see #initMenuBar
    * @see #initToolBar
    * @see #initConnections
    * @see #initStatusBar
    * @see #initView
    * @see #initDocument
    */
  BibleTimeApp();
	
	/** The destructor of BibleTimeApp
		*/
  ~BibleTimeApp();

  /** Use this functions to enabled menubar, toolbar and accelerator entries using the menuid of the action.
  	*
  	* @param id_ This is the ressource id of the entry
  	*/
  void enableCommand(int id_);

  /** Use this functions to disabled menubar, toolbar and accelerator entries using the menuid of the action.
  	*
  	* @param id_ This is the ressource id of the entry
  	*/
  void disableCommand(int id_);
	
	/** returns a pointer to the current document connected to the KTMainWindow instance
		* BibleTimeDoc should _not_ be used in BibleTimeView or any other class,
		* try to connect every signal of doc  etc in BibleTimeApp
		*/	
	BibleTimeDoc* getDocument() const; 	
	
	/** set some options that can be set only after it shows itself
		*/
	void setOptions();

public slots:
  /** switch argument for slot selection by menu or toolbar ID
  	*/
  void commandCallback(int id_);

  /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries.
  	*/
  void statusCallback(int id_);

  /** open a new application window by creating a new instance of BibleTimeApp
  	*/
  void slotFileNewWindow();

  /** asks for saving if the file is modified, then closes the actual file and window
  	*/
  void slotFileClose();

  /** print the actual file
  	*/
  void slotFilePrint();

  /** remove all entries from the print queue
  	*/
  void slotFileEmptyPrintQueue();

  /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
  	* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
  	*/
  void slotFileQuit();

  /** Pastes the content of the clipboard
  	*/
  void slotEditPaste();

  /** toggles the toolbar
  	*/
  void slotViewToolBar();

  /** toggles the text toolbar
  	*/
  void slotViewTextToolBar();

  /** toggles the statusbar
  	*/
  void slotViewStatusBar();

  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
  	* @param text the text that is displayed in the statusbar
  	*/
  void slotStatusMsg(const char *text);

  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
  	* @param text the text that is displayed in the statusbar
   	*/
  void slotStatusHelpMsg(const char *text);

	/** Sets up some properties of BibleTime
		* @short configure BibleTime
		*/
	void slotSettingsOptions();
	
	/** Shows a daily tip.
		* @short daily tip
		*/
	void slotHelpTipOfDay();
	
	/** This slot open a dialog for sending a bugreport to the BibleTime team.
		* @short bugreport dialog
	*/
  void slotHelpBugReport();

  /** show an About Window
  	*/
  void slotHelpAbout();

  /** get the text for the given key and give it back to the view
  	*/
	void slotRequestBrowserTextForEditor(const QString&);
	
  /** toggle the view of the notes editor
  	*/
  void slotViewTNotesEditor();

  /** show only browsers (true/false)
  	*/
  void slotViewBigBrowser();

  /** toggle the view of Strongs numbers
  	*/
	void slotViewDisplayStrongs();

  /** toggle the view of footnotes
  	*/
	void slotViewDisplayFootnotes();
 	
 	/** Sets the selected tabs of BibleTimeView at startup. It's called by main().
		* @short Sets the tabs of BibleTimeView
		*/
  void slotSetCurrentTabs();

  /** Is called when the current key changed
  	*/
	void slotLookupKeyChanged(const char*);
	
  /** Is called when the current text has changed
  	*/
	void slotLookupTextChanged(const char*);
	
	/** signals the key as text
		*/
	void slotSetCurrentKeyVerse(const QString&);
	
	/** signals the key text, the module name and its type
		*/
	void slotSetCurrentKeyModule(const QString&, const QString&, const QString&);

  /** Is called when the user pressed RETURN in the lookupline
		*/
  void slotLookupReturnPressed();
	
	/** Set instantlookup on or off  depending on the state of the lookupcheckbox
		* @short sets instant lookup on or off
		*/
	void slotLookupCheckBoxClicked();
	
	/** Moves to the previous entry in the history
		*/
	void slotHistoryBack(int);
	
	/** It's called when the user selected an item of the history_next poup
		* @short Called when the user selceted an item in the history-next popup
		*/
	void slotHistoryNext(int);
	
	/** Moves to the provious item in the hostory.
		*/	
	void slotHistoryMoveToPrev();
	
	/** Moves to the next entry in the history
		*/
	void slotHistoryMoveToNext();
	
	/** Saves the QStrList to a file with. The lst contains the searchresult the user want to save
		*/	
	void slotSaveListToFile(QStrList*, bool);
	
	/** Copies the contents or onyl the versname to the clipboard.
		*/	
	void slotCopyListToClipboard(QStrList*, bool);
	
	/**Send the givene list to the internal printer queue
		*/
	void slotPrintList(QStrList*, bool);
	
	void slotPrintText( const QString&, bool, const QString&, bool );

  /** send an email to the given address
  	*/
  void slotSendEmail(const char *name, const char *email);

  /** open the given URL in KFM
  	*/
  void slotOpenURL(const char *url);

  /** If you change to the dictionary tab the move to next / prev. chapter are disabled
  	* Otherwise they'll be enabled.
	  */
  void slotTTabChanged(int);

  /** This is called when the selction in one of the browser changes.
  	* We use this to set some selction dependant part (EDIT-COPY ...)
  	*
  	* @param KHTMLView*	The view of which the selction changed
  	* @param KHTMLView*	True if there is selcted text, false if there s none
  	*/
  void slotBrowserSelectionChanged(KHTMLView *, bool);

  /** This is called when the selection in the noteseditor changed
  	*
  	* @param KWriteView* The kwrite widget of which the selction changed
  	* @param bool True if there is selcted text, false if there s none
  	*/
  void slotNotesEditorSelectionChanged(KWriteView*, bool);;
	
protected:
 	/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
		* file
		*/ 	
	void saveOptions();
	
	/** read general Options again and initialize all variables like the recent file list
	  */
	void readOptions();
	
	/** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
		* @see KAccel
		*/
	void initKeyAccel();
	
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
  	* @see KApplication#getHelpMenu
  	*/
  void initMenuBar();

  /** this creates the toolbars.
    */
  void initToolBar();

  /** sets up the statusbar for the main window by initialzing a statuslabel.
  	*/
  void initStatusBar();

	/** initializes the document object of the main window that is connected to the view in initView().
		* @see initView();
		*/
	void initDocument();
	
  /** creates the centerwidget of the KTMainWindow instance and sets it as the view
  	*/
  void initView();

  /** initialize our Printer class
  	*/
  void initPrinter();

	/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
		* default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
		* be saved if Modified; on cancel the closeEvent is rejected.
		*
		* @see KTMainWindow#queryClose
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryClose();
	
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
		* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
		* properties.
		*
		* @see KTMainWindow#queryExit
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryExit();
	
	/** Updates the history by setting up the popupmenus from the QStrList
		* @short sets up history
		*/
	void updateHistory();
	
	/** add one key / module pair to the history list
		*/
	void addToHistory(const QString&, const QString&);
	
	/** create the keytext for the Popup menu
		*/
	QString createHistoryKey(const QString&, const QString&);
	
	/** execute an external command via KProcess
		*/
  int executeCommand(const QString &command, KProcess::RunMode rm);

  /** Updates the key accels and it's menus
  	*/
  void setKeyAccels();

  /** Initializes the connections of different SLOTS and SIGNALS
  	*/
  void initConnections();

  /** Sets the caption of the mainwindow.
  	*/
  void setCaption(const QString);

protected slots:
  /** Toggles the "instant lookup" checkbox in the toolbar.
		*/
  void slotToggleLookupCheckBox();

  /** Calls the helpprogram of KDE
  	*/
  void slotHelpContents();

  /** Stores the list tzo sen them later to BibleTimeView.
		* We can't connect directly to View because Doc
		* sends the signal before View is created.
		*/
  void slotSetBibleFont( QList<TBibleFont>*);

  /** This is called when the content of the clipboard changed.
  	* We use this to enable or to disable clipboard related functions like PASTE
    */
  void slotClipboardChanged();


private:
 	/** a process object to execute external commands
 		*/
  KShellProcess process;

	/** the configuration object of the application
		*/
	KConfig* config;
	
	/** the key accelerator container
		*/
	CKNewAccel* key_accel;
	
	/** our printer manager
		*/
	BibleTimePrinter	*btPrinter;

  /** file_menu contains all items of the menubar entry "File"
  	*/
  QPopupMenu *file_menu;

  /** edit_menu contains all items of the menubar entry "Edit"
  	*/
  QPopupMenu *edit_menu;

  /** view_menu contains all items of the menubar entry "View"
  	*/
  QPopupMenu *view_menu;

  /** help_menu contains all items of the menubar entry "Help"
  	*/
  QPopupMenu *help_menu;

  /** settings_menu contains items for the settings
  	*/
  QPopupMenu *settings_menu;

  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  BibleTimeView *view;

  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  BibleTimeDoc *doc;

//history stuff
	/** Contains the previous history
		*/
	QPopupMenu 		*history_prev;
	
	/** Contains the following history
		*/
	QPopupMenu 		*history_next;
	
	/** Contains the history items
		*/
	HistoryList		*history_list;
	
	KeyVerseList	*verseList;

//toolbar stuff
	/** The editline in the toolbar
		*/
	KLined 				*lookupLine;
	
	/** The label in the toolbar
		*/
	QLabel				*lookupLabel;

	/** The "instant lookup" checkbox in the toolbar
		*/	
	QCheckBox			*lookupCheckBox;
	
	/** This list contains the fonts we use in in BibleTime. The list is also used by the fontmanager
		*/
	QList<TBibleFont>* 	fontList;
	
	/** True if there's selected text  in one of the browser parts, otherwise False
		*/
	bool	browserHasSelection;
	
	/** True if there's selected text in the noteseditor part, otherwise False
		*/
	bool	notesEditorHasSelection;
};
 
#endif // BIBLETIME_H