/***************************************************************************
                          bibletimeview.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 15:34:26 CEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/bibletimeview.h,v 1.8 1999/10/31 14:58:37 jockel Exp $ */
/* $Revision: 1.8 $ */

#ifndef BIBLETIMEVIEW_H
#define BIBLETIMEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qlistbox.h>
#include <qstrlist.h>
#include <qsplitter.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qregexp.h>

//include file for KDE
#include <knewpanner.h>
#include <htmlview.h>
#include <kconfig.h>
#include <htmlview.h>

//own inlude files
#include "bibletime.h"
#include "bibletimedoc.h"
#include "ceditwidget.h"
#include "ctabctl.h"
#include "cdocbrowser.h"
#include "SearchTextDialog.h"
#include "SearchScopeDialog.h"
#include "cnoteseditor.h"
#include "bookmarkmanager.h"
#include "resource.h"
#include "cresultlistbox.h"
#include "klistview.h"
#include "structdef.h"

/** The BibleTimeView class provides the view widget for the BibleTimeApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As BibleTimeView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the BibleTimeApp class to manipulate and display
	* the document structure provided by the BibleTimeDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
	* @see BibleTimeApp
 	*/
class BibleTimeView : public KNewPanner
{
  Q_OBJECT

  friend BibleTimeApp;

public:
  /** Constructor for the main view
  	*
  	*	@param parent The parwntwidget of the view
  	* @param name	The identifier
  	* @see QWidget
  	*/
  BibleTimeView(QWidget* parent = 0, const char* name=0);

  /** Destructor for the main view
  	*/
  ~BibleTimeView();

  /**	Init the view. Creates widgets and the other GUI stuff
 		*/
  void initView();
	
	/** Initializes the connections of the SIGNALs of the child widgets to SLOTs of this class.
		*	Also connect SIGNALs from child widgets to own SIGNALs.
	*/
  void initConnections();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a BibleTimeApp instance as a parent
		* widget to get to the window document pointer by calling the BibleTimeApp::getDocument() method.
		*
		* @see BibleTimeApp#getDocument
		* @return Returns the used document.
		*/
	BibleTimeDoc* getDocument() const;
	
	/** Set the recent modules in the browsers on startup.
		*/
	void setRecentModules();
	
public slots:
 	/** This SLOT will be called to select the gicen modulname in on of the trees.
 		*
 		* @param QString	The modulename
 		*/
 	void activateModule(const QString&);
	
 	/** This SLOT will be called to select the gicen modulname in on of the trees. This will also
 		*	show the key of the module.
 		*
 		* @param QString	The modulename
 		*	@param QSTring	The key to show
 		*/	
	void activateModuleAndKey(const QString &, const QString &);
	
	/** Toggle the view of the notes editor.
		*
		* @param bool If true show the noteseditor, if false hide the editor.
		*/
	void slotViewTNotesEditor(bool);

	/** Changes the browser colors.
		*/
	void slotChangeBrowserColors( const QColor&, const QColor&,const QColor&, const QColor&, const bool);

  /** Sets the fixed font of the browser to the given name.
  	*
  	* @param char	The name of the fixed font.
	  */
  void slotBrowserFixedFont(const char*);

  /** Changes the size of the browserfont to the given one.
  	*
  	* @param int The new size of the browserfont.
  	*/
  void slotBrowserFontSize(int);

  /** Changes the standard font of the browser to the given name.
  	*
  	* @param char	The new standard font of the browser
  	*/
	void slotBrowserStandardFont(const char*);
	
  /** Sets the current tabs. This is used for initialisation afetr startup.
  	*/
	void slotSetCurrentTabs();
	
	/** maximize / minimize the browsers
		*
		* @param bool If true use big browser otherwise set to normal state.
		*/
	void slotViewBigBrowser(bool);
	
	/** Sets the list of modules used in BibleTime.
		*
		* @param ModuleDefintionList	The list of modules.
		*/
	void slotSetModuleList(ModuleDefinitionList*);
	
	/**
		*/
	void slotFindModule(const QString&);
	
	/**
		*/
	void slotSetHTMLText(const QString&, const QString&);
	
	/** This calls some functions to update the current key (bookmarkmanager, noteseditor ...)
	*/
	void slotSetCurrentKeyText(const QString&);
	
	/**
		*/
	void slotSetCurrentKeyVerse(const QString&);
	
	/**
		*/
	void slotSetCurrentKeyModule(const QString&, const QString&, const QString&);
	
	/**
		*/
	void slotSetSearchResult(QStrList*);
	
	/**
		*/
	void slotSelectTTabPage (int);
	
	/**
		*/
	void slotSelectSTabPage (int);
	
	void slotSearchCurrentModule(BibleTimeApp::SearchType, bool, const QString&);
	
	/**	This slot gets the text from the application and places it into the
		*	editor.
		*/
	void slotRequestBrowserTextForEditor(const QString&);
 	
 	/** Have one item of text (possibly key and data to print
 		*/
 	void slotPrintText( const QString&, bool, const QString&, bool );
 	
 	/** Is called when an URL was selected from one of the browsers
 		*/
 	void slotURLSelected(KHTMLView*, const char*,int, const char*);
 	
	/** Search in the current text
		*/
 	void slotSearchText();

  /** Pastes the text of the clipoard into the noteseditor
  	*/
  void slotPaste();

	/** If there's selcted text in the noteseditor this function cuts this text into the clipboard.
		*/
  void slotCut();

  /** Call this SLOT to copy the currently selected text to the clipboard.
  	* This function looks first if there's selected text in one og the browser and later in the noteseditor fot selected text.
  	*/
	 void slotCopy();
	
	/**
		*/
	void slotActivateBrowserTab();

  /** Sets the font of the
		* HTML widget (e.g. hebrew).
		*/
  void setBibleFontList(QList<TBibleFont>*);

  /** Sets the font og the bible-browser
  	*/
  void slotSetBrowserFont(QString, QString);

  /** Shows the URL in the curret browserwidget
  	*/
  void showURL(const char*);

  /** Call this SLOT if you want to refresh the list containng the links put together in the linkmanager.
  	* At the moment this function rereshes the linklists in the browserwidgets.
  	*
  	*/
  void slotRefreshLinkLists();

  /** This SLOT is called when the user selected an entry in one of the slots. This function checks
  	* which tree was selected.
  	*
  	* @param int	The module which was selected in one of the trees.
    */
  void slotSetTextModule( int );

  /** This SLOT is called when the user selected an entry in one of the slots. This function checks
  	* which tree was selected.
  	*
  	* @param int	The module which was selected in one of the trees.
    */
  void slotSetLexiconModule( int );

  /** This SLOT is called when the user selected an entry in one of the slots. This function checks
  	* which tree was selected.
  	*
  	* @param int	The module which was selected in one of the trees.
    */
  void slotSetCommentModule( int );

signals:
	/**	Is emitted when a new module was chosen in one of the trees.
		*	
		* @param QString	The name of the chosen module
		*/
	void sigModuleChosen(const QString&);
	
	/**
		*/
	void sigSetCurrentModule(const QString&);
	
	/** Use this text if you want to display a key.
		*
		* @param char	Contains the key you want to show
		*/
	void sigLookupTextChanged(const char*);
	
	/**
		*/
	void sigSearchCurrentModule(BibleTimeApp::SearchType, bool, const QString&);
	
	/** Use this SIGNAL to reset the search scope.
		*/
	void sigResetSearchScope();
	
	/**
		*/
	void sigSetSearchScope();
	
	/**
		*/
	void sigSetSearchScope(const QString&, const QString&);
	
	/**
		*/
	void sigCurrentKeyRequested();

	void sigResultListSelection(const char*);
	void sigSearchInModule(const QString&, const QString&);
	
	/** add a comment to the personal comment module
		*/
	void sigPersonalCommentAdd(const QString&, const QString&, const QString&, const QString&);
	
	/** remove the given comment from the comment module
		*/
	void sigPersonalCommentRemove(const QString&, const QString&, const QString&);
	
	/** send a request that the text for the given key is needed as raw ascii
		*/
	void sigRequestBrowserTextForEditor(const QString&);
	
	/** This SIGNAL is emitted if you want to print the list into the clipboard.
		*
		* @param QStrList	This list contains the keys you want to print.
		*	@param bool			If it's true print the list together with the text of each key, otherwhise print only the keyname.
		*/
 	void sigSaveListToFile(QStrList*,bool);
 	
	/** This SIGNAL is emitted if you want to copy the list into the clipboard.
		*
		* @param QStrList	This list contains the keys you want to copy.
		*	@param bool			If it's truecopy the list together with the text of each key, otherwhise copy only the keyname.
		*/
 	void sigCopyListToClipboard(QStrList*,bool);
 	
	/** With the help of this signal you can print the list send with this SIGNAL.	
		*
		* @param QStrList	Contains keys you want to print
		*	@param bool			If true the keys will be printed together with the text of the key. Otherwise print only the keyname.		
		*/
 	void sigPrintList(QStrList*,bool);
 	
 	/** Have one item of text (possibly key and data) to print
 		*/
 	void sigPrintText( const QString&, bool, const QString&, bool );
	
	/** Send this SIGNAL if you want to put some text into the statusbar.
		*
	  *@param char	The text you want to put into the statusbar.
		*/
 	void sigStatusbarMsg(const char*);
 	
	/**
		*/
 	void sigTTabChanged(int);
 	
	/**
		*/
 	void sigBrowserSelectionChanged(KHTMLView*, bool);
 	
	/** This is emitted when the the selectio of the noteseditor changed. This SIGNAL is connected to the noteseditor.
		*
		* @param KWriteView The KWrite object where the selection changed
		*	@param bool	If true there's selected text, otherwhise there's no selected text
		*/
 	void sigNotesEditorSelectionChanged(KWriteView*, bool);
		
private:
	KConfig						*config;
	
	KNewPanner				*leftPanner;
	KNewPanner				*rightPanner;
	
	CTabCtl						*treeTabView;
	CTabCtl						*browserTabView;
	CTabCtl						*searchTabView;
	
	CResultWidget			*searchResultWidget;
	
	KListView					*textTree;
	KListView					*lexTree;
	KListView					*commTree;	
	
	BookmarkManager		*bookmarkTree;
	SearchTextDialog	*searchTextDialog;
	SearchScopeDialog	*searchScopeDialog;
	
	CDocBrowser				*textBrowserWidget;
	CDocBrowser				*lexBrowserWidget;
	CDocBrowser				*commBrowserWidget;
	
	CNotesEditor			*notesEditor;
	int								rightPannerPosition;
	int 							globalPannerPosition;
	QList<TBibleFont>	*fontList;
	ModuleDefinitionList	*_moduleList;
	
	// the last opened module of each type
	QString						recentText;
	QString						recentLexicon;
	QString						recentComment;
	QString						currentKey;
	
protected:
	/** This funtion saves the parameters
		* of the class BibleTimeView like
		* the position of the dividers of the
		*	panners.
		*/
	void saveOptions();	
	
	/** This funtion reads the parameters
		* of the class BibleTimeView like
		* the position of the dividers of the
		* panners.
		*/
	void readOptions();
	
	/** Convert HTML Code to ASCII
		*/
	QString convertToText(const QString&);
	
	/** search an entry in a tab view and highlight it
		*	@return Rteurns true if the entry was found, otherwhise return false.
	  */
	bool highlightTabEntry(KListView*,const QString&, bool setRecent = false);

  /** Implmentation of the resizeEvent. Handles
		* the different parts and correct their sizes if they
		* are partially hidden.
		*/
  virtual void resizeEvent( QResizeEvent *event );
};

#endif // BIBLETIMEVIEW_H