/***************************************************************************
                          cnoteseditor.cpp  -  description
                             -------------------
    begin                : Mon Aug 30 1999
    copyright            : (C) 1999 by Joachim Ansorg
    email                : Jockl123@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

//QT includes
#include <qregexp.h>

//KDE includes
#include <kapp.h>
#include <kquickhelp.h>
#include <kiconloader.h>

//own includes
#include "cnoteseditor.h"

//defines to make changing the look of the NotesEditor easier
#define BUTTON_SPACE	3
#define	BUTTON_SIZE		23
#define	BUTTON_BAR_HEIGHT	29

CNotesEditor::CNotesEditor(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	this->setMinimumSize(150,110);

	config = kapp->getConfig();

	editWidget = new CEditWidget(kapp, this, "editWidget");
	editWidget->setFocusPolicy(QWidget::StrongFocus);	

	addButton	= new QPushButton(this, "addButton");
	addButton->setGeometry(BUTTON_SPACE, BUTTON_SPACE, BUTTON_SIZE, BUTTON_SIZE);
	addButton->setPixmap(ICON("mini-checkmark.xpm"));
	KQuickHelp::add(addButton,i18n("<B>Creates the comment</B><BR><BR>Use this button to add the text<BR>in the editor as a comment for the given key."));

	editButton = new QPushButton(this,"addButton");
	editButton->setGeometry(BUTTON_SIZE+2*BUTTON_SPACE, BUTTON_SPACE, BUTTON_SIZE, BUTTON_SIZE);
	editButton->setPixmap(ICON("mini-edit.xpm"));	
	KQuickHelp::add(editButton,i18n("<B>Edits the comment</B><BR><BR>Sets the text in the editor<BR>to the text of the given comment."));

	deleteButton = new QPushButton(this, "addButton");
	deleteButton->setGeometry(2*BUTTON_SIZE+3*BUTTON_SPACE, BUTTON_SPACE, BUTTON_SIZE, BUTTON_SIZE);
	deleteButton->setPixmap(ICON("mini-trash.xpm"));
	KQuickHelp::add(deleteButton,i18n("<B>Deletes the comment</B><BR><BR>Deletes the comment of the given key."));

	fromKeyEdit = new QLineEdit(this, "fromKeyEdit");
	fromKeyEdit->setFocusPolicy(QWidget::StrongFocus);	
	KQuickHelp::add(fromKeyEdit, i18n("<B>Start key</B><BR><BR>Represents the start of the comment."));

	toKeyEdit = new QLineEdit(this,"toKeyEdit");
	toKeyEdit->setFocusPolicy(QWidget::StrongFocus);	
	KQuickHelp::add(toKeyEdit, i18n("<B>End key</B><BR><BR>Represents the end verse of the comment."));
	
//connect the signals
	connect(addButton, SIGNAL(clicked()),
					this, SLOT(slotAddButtonClicked()));
	connect(deleteButton, SIGNAL(clicked()),
					this, SLOT(slotDeleteButtonClicked()));
	connect(editButton, SIGNAL(clicked()),
					this, SLOT(slotEditButtonClicked()));
	
	connect(editWidget, SIGNAL(markStatus(KWriteView*, bool)),
					this, SIGNAL(sigNotesEditorSelectionChanged(KWriteView*, bool)));
}

CNotesEditor::~CNotesEditor()
{
	if (addButton != 0)
		delete addButton;
	if (deleteButton != 0)
		delete deleteButton;
	if (editButton != 0)
		delete editButton;
	if (toKeyEdit != 0)
		delete toKeyEdit;
	if (fromKeyEdit != 0)
		delete fromKeyEdit;
	if (editWidget != 0)
		delete editWidget;
}

/** The resizeEvent implementation. */
void CNotesEditor::resizeEvent( QResizeEvent *event )
{
	editWidget->setGeometry(0,BUTTON_BAR_HEIGHT,this->width(), this->height()- BUTTON_BAR_HEIGHT);

	fromKeyEdit	->setGeometry(3*BUTTON_SIZE+4*BUTTON_SPACE, BUTTON_SPACE, (this->width()- 3*BUTTON_SIZE - 5*BUTTON_SPACE) /2, BUTTON_SIZE);
	toKeyEdit		->setGeometry(3*BUTTON_SIZE+5*BUTTON_SPACE+fromKeyEdit->width(), BUTTON_SPACE, (this->width()- 3*BUTTON_SIZE - 6*BUTTON_SPACE)/2, BUTTON_SIZE);
}

/** Copies the current text of the editWidget into
the clipboard. */
void CNotesEditor::slotCopy()
{
	editWidget->copy();
}

void CNotesEditor::slotCut()
{
	editWidget->cut();
}

void CNotesEditor::slotPaste()
{
	editWidget->paste();
}


/** Checks if there is any sekected text */
bool CNotesEditor::isTextSelected()
{
	if (editWidget->markedText() != "")
		return true;
	else
		return false;
}

/** Set the QString text as the text of the editWidget. */
void CNotesEditor::setText(QString text)
{
	editWidget->setText( text );
}

void CNotesEditor::slotAddButtonClicked()
{
	QString start = fromKeyEdit->text();
	QString stop  = toKeyEdit->text();
	QString module = "-+*Personal*+-";
	QString comment = 0;

	if (stop.isEmpty())
		stop = start.copy();
	if (editWidget)
		comment = editWidget->text();
	if (!comment.isEmpty())
	{
		// SWORD takes single '\n', so, double them
		comment.replace( QRegExp("\\n\\n+"), "#UHL_P#" );
		comment.replace( QRegExp("\\n"), "\n\n" );
		comment.replace( QRegExp("#UHL_P#"), "\n\n\n" );
		emit sigPersonalCommentAdd(module, start, stop, comment);
	}
}

void CNotesEditor::slotDeleteButtonClicked()
{
	if (currentModule.contains("-+*Personal*+-", false))
	{
		QString start = fromKeyEdit->text();
		QString stop  = toKeyEdit->text();
		QString module = "-+*Personal*+-";

		if (stop.isEmpty())
			stop = start.copy();

		if (!start.isEmpty())
			emit sigPersonalCommentRemove(module, start, stop);
	}
}

void CNotesEditor::slotEditButtonClicked()
{
	if (currentModule.contains("-+*Personal*+-", false))
		emit sigRequestBrowserTextForEditor( fromKeyEdit->text() );
}

void CNotesEditor::slotSetCurrentKeyVerse(const QString &t)
{
	fromKeyEdit->setText( t.data() );
	toKeyEdit->setText( t.data() );
}

void CNotesEditor::slotSetCurrentModule(const QString &m)
{
	currentModule = m;
}

void CNotesEditor::slotSettingsEditor()
{
  editWidget->optDlg();
	saveOptions();
}

void CNotesEditor::slotSettingsEditorColors()
{
  editWidget->colDlg();
	saveOptions();
}

void CNotesEditor::slotSettingsSyntaxHighlightingDefaults()
{
  editWidget->hlDef();
	saveOptions();
}

void CNotesEditor::slotSettingsSyntaxHighlighting()
{
  editWidget->hlDlg();
	saveOptions();
}

void CNotesEditor::readOptions()
{
  config->setGroup("KWrite Options");
	editWidget->readConfig(config);	
	editWidget->doc()->readConfig(config);
}

void CNotesEditor::saveOptions()
{
	config->setGroup("KWrite Options");
  editWidget->writeConfig(config);
  editWidget->doc()->writeConfig(config);
}


