/***************************************************************************
                          cnoteseditor.h  -  description                              
                             -------------------                                         
    begin                : Mon Aug 30 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CNOTESEDITOR_H
#define CNOTESEDITOR_H

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlineedit.h>

#include <kconfig.h>
//own includes
#include "ceditwidget.h"
#include <./kwrite/kwdoc.h>

/** This class provides a view for eeditong commentaries. It provides buttons to add, edit and delete comments.
	*
  * @short The noteseditor of BibleTime. Provides interface to work with commentaries.
  * @author Joachim Ansorg
  */
class CNotesEditor : public QWidget
{
   Q_OBJECT
public:
	/** The constructor of this widget
		*/	
	CNotesEditor(QWidget *parent=0, const char *name=0);
	
	/** The destructor of this widget
		*/
	~CNotesEditor();

  /** Checks if there is any sekected text
  	*
  	* @return Returns true if there is selcted text otherwhise return false
  	*/
  bool isTextSelected();

  /** Set the text of this widget
  	*
  	* @param text The text which will be set to the widget
  	*/
  void setText(QString text);

  /** Saves the properties of this editorwidget
  	*/
  void saveOptions();;

  /** Load the saved properties of this widget
  	*/
  void readOptions();

protected:
	CEditWidget	*editWidget;

	QPushButton	*addButton;
	QPushButton	*deleteButton;
	QPushButton	*editButton;
	QLineEdit		*fromKeyEdit;
	QLineEdit		*toKeyEdit;
	
	KConfig			*config;

protected: // Protected methods
  /** The resizeEvent implementation. */
  virtual void resizeEvent( QResizeEvent *event );

public slots: // Public slots
  void slotPaste();
  void slotCut();
  /** Copies the current text of the editWidget into
	*the clipboard.
	*/
  void slotCopy();
	void slotSetCurrentKeyVerse(const QString &t);
	void slotSetCurrentModule(const QString &m);
  /**  */
  void slotSettingsSyntaxHighlighting();
  /**  */
  void slotSettingsSyntaxHighlightingDefaults();
  /**  */
  void slotSettingsEditorColors();
  /**  */
  void slotSettingsEditor();

protected slots: // Protected slots
  /**  */
  void slotAddButtonClicked();
  void slotDeleteButtonClicked();
  void slotEditButtonClicked();

signals: // Signals
  void sigRequestBrowserTextForEditor(const QString&);
	void sigPersonalCommentAdd(const QString&, const QString&, const QString&, const QString&);
	void sigPersonalCommentRemove(const QString&, const QString&, const QString&);
  void sigNotesEditorSelectionChanged(KWriteView*, bool);
	
private:
	QString			currentModule;	
};

#endif