/*
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 *
 *	 Adapted for BibleTime by Torsten Uhlmann, TUhlmann@gmx.de
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _ADVANCED_PRINTER_H_
#define _ADVANCED_PRINTER_H_

#include <time.h>

#include <qstring.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>

//#include "printerdialog.h"

struct SPageSize
{
  uint width;
  uint height;
};

struct SPageMargin
{
  uint top;
  uint right;
  uint bottom;
  uint left;
};


struct SPageHeader
{
  enum EHeaderString
  {
    NoString = 0,
    DateTime,
    PageNumber,
    FreeString
  };

  enum EHeaderLine
  {
    NoLine = 0,
    SingleLine,
    Rectangle
  };

  bool enable;
  EHeaderString pos[3]; // left, center, right
  EHeaderLine   line;
};

struct SPagePosition
{
  uint curPage;
  uint maxPage;
  time_t now;
};


class AdvancedPrinter : public QPrinter
{
  public:
    AdvancedPrinter( void );
    ~AdvancedPrinter( void );

    bool setup ( QWidget * parent = 0 );

    void setAsText( bool state );
    void setAll( bool state );
    void setSelection( bool state );
    void setRange( bool state, uint start=0, uint stop=0 );
    void setOutputToStdout( bool state );
    void setScaleToFit( bool state );
    void setPrintBackWhite( bool state );
    void setPageMarginMM( uint top, uint bottom, int right, int left );
    void setTopMarginMM( uint value );
    void setLeftMarginMM( uint value );
    void setBottomMarginMM( uint value );
    void setRightMarginMM( uint value );
    void setPageHeader( bool enable, uint left, uint center, uint right, 
			uint line );
    void setPageFooter( bool enable, uint left, uint center, uint right, 
			uint line );

    inline bool asText( void );
    inline bool all( void );
    inline bool selection( void );
    inline bool range( void );
    inline uint startRange( void );
    inline uint stopRange( void );
    inline bool outputToStdout( void );
    inline bool scaleToFit( void );
    inline bool printBlackWhite( void );
    inline SPageHeader pageHeader( void );
    inline SPageHeader pageFooter( void );
    SPageMargin pageMargin( void );
    SPageMargin pageMarginMM( void );
    SPageSize   pageFullSize( void );
    SPageSize   pageUsableSize( void );
  	/** prints the defined footer on the page */
  	bool printFooter(QPainter*);
  	/** prints the defined header on the page */
  	bool printHeader(QPainter*);
  	/** includes own functionality to the derived newPage function */
  	bool newPage();
  	/** give a free formatted string which can
				be printed in Header and Footer */
  	void setHeaderFreeString(const QString&);
	  /** get the application name that handles
				previews */
  	QString getPreviewApplication();
  	/** set the application that handles previews */
  	void setPreviewApplication(const QString&);
  	/** get the preview value */
  	bool getPreview();
  	/** do we preview or print really */
  	void setPreview(bool preview);

	protected:  	
  	bool drawHeader(QPainter*, int, int, int, bool, const SPageHeader*, const SPagePosition*);
  	
	private:
    bool 					mAsText;
    bool 					mAll;
    bool 					mInSelection;
    bool 					mInRange;
    bool 					mOutputToStdout;
    bool 					mScaleToFit;
    bool 					mPrintBlackWhite;
    bool					mPreview;
    uint  				mStartOffset;
    uint        	mStopOffset;
    QString				mPreviewApplication;
    QString     	mFreeString;
    SPageMargin 	mPageMargin;
    SPageHeader 	mHeader;
    SPageHeader 	mFooter;
    SPagePosition mPosition;
};


inline bool AdvancedPrinter::asText( void )
{
  return( mAsText );
}

inline bool AdvancedPrinter::all( void )
{
  return( mAll );
}

inline bool AdvancedPrinter::selection( void )
{
  return( mInSelection );
}

inline bool AdvancedPrinter::range( void )
{
  return( mInRange );
}

inline uint AdvancedPrinter::startRange( void )
{
  return( mStartOffset );
}

inline uint AdvancedPrinter::stopRange( void )
{
  return( mStopOffset );
}

bool AdvancedPrinter::outputToStdout( void )
{
  return( mOutputToStdout );
}

inline bool AdvancedPrinter::scaleToFit( void )
{
  return( mScaleToFit );
}

inline bool AdvancedPrinter::printBlackWhite( void )
{
  return( mPrintBlackWhite );
}

inline SPageHeader AdvancedPrinter::pageHeader( void )
{
  return( mHeader );
}

inline SPageHeader AdvancedPrinter::pageFooter( void )
{
  return( mFooter );
}


#endif
