/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __DATABASE_H_
#define __DATABASE_H_

#include "debug.h"

/* TDataBase is an abstract superclass for memory based databases that
   are loaded from and saved to disk like text files in an text editor
   and disk or net based databases which are accessed on a record
   basis. */
class TDataBase {

public:
  TDataBase() {}
  
  virtual unsigned int getFieldCount() const = 0;
  virtual unsigned int getRecordCount() const = 0;
  virtual char* getFieldName(unsigned int fieldNo) const = 0;
  
  virtual char* getItemAsText(int record, int field) const = 0;
};

#endif /* __DATABASE_H */
