/***************************************************************************
                                 KPackageViewer.cpp
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "kpackageviewer.h"
#include "serverwork.h"
#include <kmsgbox.h>
#include "korapic.xpm"
#include "kpackageeditor.h"
#include <iostream.h>

KPackageViewer::KPackageViewer(QWidget* parent,const char* name) :
		KDialog( parent, name, TRUE, 1036288 )
{
	QString	oraMessage;

	QPixmap picture((const char**) kora_xpm);
	setIcon(picture);

	packageListLabel = new QLabel( this, "packageListWLabel" );
	packageListLabel->setGeometry( 15, 12, 110, 20 );
	packageListLabel->setMinimumSize( 110, 20 );
	packageListLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageListLabel->setFont( font );
	}
	packageListLabel->setFocusPolicy( QWidget::NoFocus );
	packageListLabel->setBackgroundMode( QWidget::PaletteBackground );
	packageListLabel->setFontPropagation( QWidget::NoChildren );
	packageListLabel->setPalettePropagation( QWidget::NoChildren );
	packageListLabel->setFrameStyle( 0 );
	packageListLabel->setLineWidth( 1 );
	packageListLabel->setMidLineWidth( 0 );
	packageListLabel->QFrame::setMargin( 0 );
	packageListLabel->setText( i18n("List of packages:") );
	packageListLabel->setAlignment( 289 );
	packageListLabel->setMargin( -1 );

	packageList = new QListBox( this, "packageWList" );
	packageList->setGeometry( 10, 39, 480, 94 );
	packageList->setMinimumSize( 440, 90 );
	packageList->setMaximumSize( 32767, 32767 );
	connect( packageList, SIGNAL(highlighted(int)), SLOT(packageListClickedCB(int)) );
	packageList->setFocusPolicy( QWidget::StrongFocus );
	packageList->setBackgroundMode( QWidget::PaletteBase );
	packageList->setFontPropagation( QWidget::SameFont );
	packageList->setPalettePropagation( QWidget::SameFont );
	packageList->setFrameStyle( 51 );
	packageList->setLineWidth( 2 );
	packageList->setMidLineWidth( 0 );
	packageList->QFrame::setMargin( 0 );
	packageList->setDragSelect( TRUE );
	packageList->setAutoScroll( TRUE );
	packageList->setScrollBar( FALSE );
	packageList->setAutoScrollBar( TRUE );
	packageList->setBottomScrollBar( FALSE );
	packageList->setAutoBottomScrollBar( TRUE );
	packageList->setSmoothScrolling( TRUE );
	packageList->setMultiSelection( FALSE );
	packageList->setAutoUpdate( TRUE );

	baseFrame = new QFrame( this, "baseWFrame" );
	baseFrame->setGeometry( 10, 143, 480, 403 );
	baseFrame->setMinimumSize( 440, 360 );
	baseFrame->setMaximumSize( 32767, 32767 );
	baseFrame->setFocusPolicy( QWidget::NoFocus );
	baseFrame->setBackgroundMode( QWidget::PaletteBackground );
	baseFrame->setFontPropagation( QWidget::NoChildren );
	baseFrame->setPalettePropagation( QWidget::NoChildren );
	baseFrame->setFrameStyle( 50 );
	baseFrame->setLineWidth( 2 );
	baseFrame->setMidLineWidth( 0 );
	baseFrame->QFrame::setMargin( 0 );

	packageDeclLabel = new QLabel( baseFrame, "packageDeclWLabel" );
	packageDeclLabel->setGeometry( 10, 12, 130, 20 );
	packageDeclLabel->setMinimumSize( 130, 20 );
	packageDeclLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageDeclLabel->setFont( font );
	}
	packageDeclLabel->setFocusPolicy( QWidget::NoFocus );
	packageDeclLabel->setBackgroundMode( QWidget::PaletteBackground );
	packageDeclLabel->setFontPropagation( QWidget::NoChildren );
	packageDeclLabel->setPalettePropagation( QWidget::NoChildren );
	packageDeclLabel->setFrameStyle( 0 );
	packageDeclLabel->setLineWidth( 1 );
	packageDeclLabel->setMidLineWidth( 0 );
	packageDeclLabel->QFrame::setMargin( 0 );
	packageDeclLabel->setText( i18n("Package Declaration:") );
	packageDeclLabel->setAlignment( 289 );
	packageDeclLabel->setMargin( -1 );

	declEditButton = new QPushButton( this, "declEditWButton" );
	declEditButton->setMinimumSize( 120, 30 );
	declEditButton->setMaximumSize( 120, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		declEditButton->setFont( font );
	}
	connect( declEditButton, SIGNAL(clicked()), SLOT(declEditButtonClickedCB()) );
	declEditButton->setFocusPolicy( QWidget::TabFocus );
	declEditButton->setBackgroundMode( QWidget::PaletteBackground );
	declEditButton->setFontPropagation( QWidget::NoChildren );
	declEditButton->setPalettePropagation( QWidget::NoChildren );
	declEditButton->setText( i18n("Edit declaration") );
	declEditButton->setAutoRepeat( FALSE );
	declEditButton->setAutoResize( FALSE );
	declEditButton->setToggleButton( FALSE );
	declEditButton->setDefault( FALSE );
	declEditButton->setAutoDefault( TRUE );
	declEditButton->setIsMenuButton( FALSE );






	packageDeclMultiText = new QMultiLineEdit( baseFrame, "packageDeclWMultiText" );
	packageDeclMultiText->setGeometry( 10, 39, 460, 117 );
	packageDeclMultiText->setMinimumSize( 400, 80 );
	packageDeclMultiText->setMaximumSize( 32767, 32767 );
	{
		QFont font( "courier", 12, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageDeclMultiText->setFont( font );
	}
	packageDeclMultiText->setFocusPolicy( QWidget::StrongFocus );
	packageDeclMultiText->setBackgroundMode( QWidget::PaletteBase );
	packageDeclMultiText->setFontPropagation( QWidget::SameFont );
	packageDeclMultiText->setPalettePropagation( QWidget::SameFont );
	packageDeclMultiText->setFrameStyle( 51 );
	packageDeclMultiText->setLineWidth( 2 );
	packageDeclMultiText->setMidLineWidth( 0 );
	packageDeclMultiText->QFrame::setMargin( 0 );
	packageDeclMultiText->insertLine( "" );
	packageDeclMultiText->setReadOnly( TRUE );
	packageDeclMultiText->setOverwriteMode( FALSE );
	packageDeclMultiText->setAutoUpdate( TRUE );

	packageBodyLabel = new QLabel( baseFrame, "packageBodyWLabel" );
	packageBodyLabel->setGeometry( 10, 168, 100, 20 );
	packageBodyLabel->setMinimumSize( 100, 20 );
	packageBodyLabel->setMaximumSize( 32767, 20 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageBodyLabel->setFont( font );
	}
	packageBodyLabel->setFocusPolicy( QWidget::NoFocus );
	packageBodyLabel->setBackgroundMode( QWidget::PaletteBackground );
	packageBodyLabel->setFontPropagation( QWidget::NoChildren );
	packageBodyLabel->setPalettePropagation( QWidget::NoChildren );
	packageBodyLabel->setFrameStyle( 0 );
	packageBodyLabel->setLineWidth( 1 );
	packageBodyLabel->setMidLineWidth( 0 );
	packageBodyLabel->QFrame::setMargin( 0 );
	packageBodyLabel->setText( i18n("Package Body:") );
	packageBodyLabel->setAlignment( 289 );
	packageBodyLabel->setMargin( -1 );

	bodyEditButton = new QPushButton( this, "bodyEditWButton" );
	bodyEditButton->setMinimumSize( 120, 30 );
	bodyEditButton->setMaximumSize( 120, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		bodyEditButton->setFont( font );
	}
	connect( bodyEditButton, SIGNAL(clicked()), SLOT(bodyEditButtonClickedCB()) );
	bodyEditButton->setFocusPolicy( QWidget::TabFocus );
	bodyEditButton->setBackgroundMode( QWidget::PaletteBackground );
	bodyEditButton->setFontPropagation( QWidget::NoChildren );
	bodyEditButton->setPalettePropagation( QWidget::NoChildren );
	bodyEditButton->setText( i18n("Edit body") );
	bodyEditButton->setAutoRepeat( FALSE );
	bodyEditButton->setAutoResize( FALSE );
	bodyEditButton->setToggleButton( FALSE );
	bodyEditButton->setDefault( FALSE );
	bodyEditButton->setAutoDefault( TRUE );
	bodyEditButton->setIsMenuButton( FALSE );



	packageBodyMultiText = new QMultiLineEdit( baseFrame, "packageBodyWMultiText" );
	packageBodyMultiText->setGeometry( 10, 195, 460, 198 );
	packageBodyMultiText->setMinimumSize( 400, 160 );
	packageBodyMultiText->setMaximumSize( 32767, 32767 );
	{
		QFont font( "courier", 12, 50, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		packageBodyMultiText->setFont( font );
	}
	packageBodyMultiText->setFocusPolicy( QWidget::StrongFocus );
	packageBodyMultiText->setBackgroundMode( QWidget::PaletteBase );
	packageBodyMultiText->setFontPropagation( QWidget::SameFont );
	packageBodyMultiText->setPalettePropagation( QWidget::SameFont );
	packageBodyMultiText->setFrameStyle( 51 );
	packageBodyMultiText->setLineWidth( 2 );
	packageBodyMultiText->setMidLineWidth( 0 );
	packageBodyMultiText->QFrame::setMargin( 0 );
	packageBodyMultiText->insertLine( "" );
	packageBodyMultiText->setReadOnly( TRUE );
	packageBodyMultiText->setOverwriteMode( FALSE );
	packageBodyMultiText->setAutoUpdate( TRUE );

	closeButton = new QPushButton( this, "closeWButton" );
	closeButton->setGeometry( 390, 558, 100, 30 );
	closeButton->setMinimumSize( 100, 30 );
	closeButton->setMaximumSize( 100, 30 );
	{
		QFont font( "helvetica", 12, 75, 0 );
		font.setStyleHint( (QFont::StyleHint)0 );
		font.setCharSet( (QFont::CharSet)0 );
		closeButton->setFont( font );
	}
	connect( closeButton, SIGNAL(clicked()), SLOT(closeButtonClickedCB()) );
	closeButton->setFocusPolicy( QWidget::TabFocus );
	closeButton->setBackgroundMode( QWidget::PaletteBackground );
	closeButton->setFontPropagation( QWidget::NoChildren );
	closeButton->setPalettePropagation( QWidget::NoChildren );
	closeButton->setText( i18n("Close") );
	closeButton->setAutoRepeat( FALSE );
	closeButton->setAutoResize( FALSE );
	closeButton->setToggleButton( FALSE );
	closeButton->setDefault( FALSE );
	closeButton->setAutoDefault( TRUE );
	closeButton->setIsMenuButton( FALSE );

	QBoxLayout* layout1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, "top" );
	layout1->addStrut( 0 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "listbase" );
	layout1->addLayout( layout1_2, 1 );
	layout1_2->addStrut( 0 );
	layout1_2->addSpacing( 10 );
	layout1_2->addWidget( packageListLabel, 1, 36 );
	layout1_2->addStretch( 10 );
	QBoxLayout* layout1_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "list" );
	layout1->addLayout( layout1_3, 1 );
	layout1_3->addStrut( 0 );
	layout1_3->addSpacing( 5 );
	layout1_3->addWidget( packageList, 1, 36 );
	layout1_3->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_5 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "frame" );
	layout1->addLayout( layout1_5, 10 );
	layout1_5->addStrut( 0 );
	layout1_5->addSpacing( 5 );
	layout1_5->addWidget( baseFrame, 1, 36 );
	QBoxLayout* layout1_5_2 = new QBoxLayout( baseFrame, QBoxLayout::TopToBottom, 5, 5, "frameBase" );
	layout1_5_2->addStrut( 0 );
	layout1_5_2->addSpacing( 5 );
	QBoxLayout* layout1_5_2_2 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "declBase" );
	layout1_5_2->addLayout( layout1_5_2_2, 1 );
	layout1_5_2_2->addStrut( 0 );
	layout1_5_2_2->addSpacing( 5 );
	layout1_5_2_2->addWidget( packageDeclLabel, 1, 36 );
	layout1_5_2_2->addStretch( 10 );
	QBoxLayout* layout1_5_2_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "decl" );
	layout1_5_2->addLayout( layout1_5_2_3, 10 );
	layout1_5_2_3->addStrut( 0 );
	layout1_5_2_3->addSpacing( 5 );
	layout1_5_2_3->addWidget( packageDeclMultiText, 1, 36 );
	layout1_5_2_3->addSpacing( 5 );
	layout1_5_2->addSpacing( 5 );
	QBoxLayout* layout1_5_2_5 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "bodyBase" );
	layout1_5_2->addLayout( layout1_5_2_5, 1 );
	layout1_5_2_5->addStrut( 0 );
	layout1_5_2_5->addSpacing( 5 );
	layout1_5_2_5->addWidget( packageBodyLabel, 1, 36 );
	layout1_5_2_5->addStretch( 10 );
	QBoxLayout* layout1_5_2_6 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "body" );
	layout1_5_2->addLayout( layout1_5_2_6, 10 );
	layout1_5_2_6->addStrut( 0 );
	layout1_5_2_6->addSpacing( 5 );
	layout1_5_2_6->addWidget( packageBodyMultiText, 1, 36 );
	layout1_5_2_6->addSpacing( 5 );
	layout1_5_2->addSpacing( 5 );
	layout1_5->addSpacing( 5 );
	layout1->addSpacing( 5 );
	QBoxLayout* layout1_7 = new QBoxLayout( QBoxLayout::LeftToRight, 5, "button" );
	layout1->addLayout( layout1_7, 1 );
	layout1_7->addStrut( 0 );
	layout1_7->addSpacing( 5 );
	layout1_7->addWidget( declEditButton, 1, 36 );
	layout1_7->addSpacing( 5 );
	layout1_7->addWidget( bodyEditButton, 1, 36 );
	layout1_7->addStretch( 10 );
	layout1_7->addWidget( closeButton, 1, 36 );
	layout1_7->addSpacing( 5 );
	layout1->addSpacing( 5 );
	resize( 500,600 );
	setMinimumSize( 0, 0 );
	setMaximumSize( 32767, 32767 );

	setCaption( i18n("View Packages") );

	// disable the edit buttons
	declEditButton->setEnabled(FALSE);
	bodyEditButton->setEnabled(FALSE);

	KApplication::setOverrideCursor(waitCursor);
	// fill the listbox of the packages
	if (ServerWork::fillPackageList(packageList, oraMessage))
	{
		// an error occured
		KApplication::restoreOverrideCursor();
		KMsgBox::message(this, i18n("Oracle Error"), oraMessage, KMsgBox::STOP);
	}

	KApplication::restoreOverrideCursor();
}


KPackageViewer::~KPackageViewer()
{
}

void KPackageViewer::packageListClickedCB(int item)
{
	QString	packageDeclResult;
	QString	packageBodyResult;
	QString	oraMessage;

	selPackageIndex = item;

	if (!ServerWork::getPackageData(item, oraMessage, selPackageName, packageDeclResult, packageDeclResultRaw,
				    packageBodyResult, packageBodyResultRaw))
	{
		KMsgBox::message(this, i18n("Package Error"), oraMessage, KMsgBox::STOP);
		return;
	}

	// ok, we have the data. Put it into the text fields
	packageDeclMultiText->clear();
	packageBodyMultiText->clear();

	packageDeclMultiText->insertLine(packageDeclResult);
	packageBodyMultiText->insertLine(packageBodyResult);

	// enable the edit buttons
	declEditButton->setEnabled(TRUE);
	bodyEditButton->setEnabled(TRUE);
}

void KPackageViewer::closeButtonClickedCB()
{
	this->close();
}

void KPackageViewer::bodyEditButtonClickedCB()
{
	KPackageEditor	editor(this);

	editor.setTitle(selPackageName);
	editor.setText(packageBodyResultRaw);
	editor.setPackageInfo(selPackageIndex, "PACKAGE BODY");
	editor.show();
	this->packageListClickedCB(selPackageIndex);

}

void KPackageViewer::declEditButtonClickedCB()
{
	KPackageEditor	editor(this);
	
	editor.setTitle(selPackageName);
	editor.setText(packageDeclResultRaw);
	editor.setPackageInfo(selPackageIndex, "PACKAGE");
	editor.show();
	this->packageListClickedCB(selPackageIndex);
}


