/***************************************************************************
                                 ServerWork.h
                             -------------------
    begin                : 01.09.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SERVER_WORK_H
#define __SERVER_WORK_H

#include <qlistbox.h>
#include <qstring.h>

class ServerWork
{
	public:
	static int connectKOraServer(QString& logonMessage);
	static int reconnectKOraServer(QString& logonMessage);
	static int connectToKOraS(const QString& server, int port, QString& logonMessage);
	static void releaseFromKOraS();
	static int connectToOracle(const QString& userid, const QString& password, const QString& connect, QString& oraMessage);
	static void releaseFromOracle();
	static int executeSql(const QString& sqlCommand, QString& oraMessage, int* processedRows, QString& sqlResult, int isSingleCommand = FALSE);
	static int descTable(const QString& tableName, QString& oraMessage, QString& sqlResult);
	static int fillSequenceList(QListBox* listbox, QString& oraMessage);
	static int getSequenceData(int index, QString& maxValue, QString& minValue, long* increment, QString& cycleFlag);
	static int fillSynonymList(QListBox* listbox, QString& oraMessage);
	static int getSynonymData(int index, QString& tableOwner, QString& tableName, QString& dbLink);
	static int fillTableList(QListBox* listbox, QString& oraMessage);
	static int getTableData(int index, QString& oraMessage, QString& tableData);
	static int fillPackageList(QListBox* listbox, QString& oraMessage);
	static int getPackageData(int index, QString& oraMessage, QString& packageName, QString& packageDeclData, QString& packageDeclDataRaw,
				  QString& packageBodyData, QString& packageBodyDataRaw);
	static QString getPlSqlCompileError(int index, const QString& type);

	private:
	static int executeKOraS(const QString& command, QString& result);
	static void fillListbox(QListBox* listbox, const QString& result);
	static QString getKOraSItem(const QString& data, int position);
	static void getKOraSConnData(QString& hostname, int* port);

};

#endif // __SERVER_WORK_H
