/***************************************************************************
    klogindlg.h  -  Logon dialog interface

    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLOGINDLG_H
#define KLOGINDLG_H

// include files for Qt
#include <qstring.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

// include files for KDE
#include <kwizard.h>

/** Dialog for getting ORACLE login parameters.
  * @author Yury Lebedev
  */
class KLoginDlg : public KDialog
{
  Q_OBJECT

  /** Top dialog layout */
  QVBoxLayout topLayout;
  /** Labels & edits layout */
  QGridLayout editLayout;
  /** Buttons layout */
  QHBoxLayout buttonLayout;

  /** Username label */
  QLabel usrLabel;
  /** Password label */
  QLabel passLabel;
  /** Database label */
  QLabel dbLabel;

  /** Username edit */
  QLineEdit usrEdit;
  /** Password edit */
  QLineEdit passEdit;
  /** Database edit */
  QLineEdit dbEdit;

  /** Login button */
  QPushButton okButton;
  /** Cancel button */
  QPushButton cancelButton;

  /** Saved 'username' string */
  QString usr;
  /** Saved 'password' string */
  QString pass;
  /** Saved 'database' string */
  QString db;

protected slots:

  /** 'Logon' button slot.
    * Check inputed strings and fill string members. */
  void slotLogon();

public:

  /** Constructs dialog and its internal widgets. */
  KLoginDlg(QWidget *parent = 0, const char* name = 0,
    const char* initialUsername = 0, const char* initialDatabase = 0);
  /** Destructor */
  ~KLoginDlg();

  /** Returns result connect string for ORACLE in their format.
    * It is non-empty if dialog is properly ended. */
  QString connectString();
  /** Returns string with ORACLE 'username@database'.
    * It is non-empty if dialog is properly ended. */
  QString identityString();
  /** Returns 'username' string after accepted dialog. */
  const char* username() { return usr; };
  /** Returns 'database' string after accepted dialog. */
  const char* database() { return db; };
};

#endif
