/***************************************************************************
                          vlangfile.cpp  -  description
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include <unistd.h>
#include <sys/stat.h>

#include <qdir.h>

#include <kapp.h>
  
#include "vlangfile.h"
#include "../vtyplist.h"

VLanguageFile::VLanguageFile( QString Language, bool ReadOnly = true ) 
{
//  QString Filename = KApplication::kde_datadir() + "/dokvok/languages/" 
//                     + Language + ".dvlc";

  
  // now for the local lang config file
  QString FileName = KApplication::localkdedir().copy();
  FileName += "/share/apps/dokvok/languages/";
  FileName += Language;
  FileName += ".dvlc"; //DokVok Language Config
  
  QFile File( FileName );
  bool Success;

  if( ReadOnly )
	  Success = File.open( IO_ReadOnly );
  else  
  {
    if( (Success = checkAccess(FileName.data(), W_OK)) )
    {
      // open or create if it does not exist yet.
      Success = File.open( IO_ReadWrite );
      // Set uid/gid (necessary for SUID programs)
      if ( Success )     
        chown( File.name(), getuid(), getgid() );
    }
  }

	if( Success )
	  LanguageFile = new KSimpleConfig( FileName, ReadOnly );
	else
	  LanguageFile = 0;
}


VLanguageFile::~VLanguageFile()
{
}


QString VLanguageFile::name()
{
  if( LanguageFile )
  {
    LanguageFile->setGroup( "General" );
    return LanguageFile->readEntry( "Name" );                                               
  }
  return "";
}


QFont VLanguageFile::font()
{
  if( LanguageFile )
  {
    LanguageFile->setGroup( "General" );
    return LanguageFile->readFontEntry( "Font" );
  }
  return QFont();
}



VTypInfoList VLanguageFile::typInfoList()
{
  VTypInfoList TypInfoList;    
  
  if( LanguageFile )
  {
    // get list of type names
    QStrList NameList;
    LanguageFile->setGroup( "General" );
    LanguageFile->readListEntry( "Types", NameList );   

    // get data of all types
    QString TypName;
    for( TypName=NameList.first(); TypName; TypName=NameList.next() )
    {
      VTypInfo *TypInfo = new VTypInfo;
    
      // read data
      LanguageFile->setGroup( "T:"+TypName );
      TypInfo->name() = TypName;
      TypInfo->localName() = LanguageFile->readEntry( "Name" );
      QString Symbol = LanguageFile->readEntry( "Symbol" );
      if( Symbol.isEmpty() )
        TypInfo->initSymbol();
      else
        TypInfo->setSymbol( Symbol[0] );
        
      TypInfoList.append( TypInfo );
    }
  }
  
  return TypInfoList;
}


void VLanguageFile::writeFont( const QFont &Font )
{
  if( LanguageFile )
  {
    LanguageFile->setGroup( "General" );
    LanguageFile->writeEntry( "Font", Font, true, false, false );
  }
}


void VLanguageFile::writeName( const QString &Name )
{
  if( LanguageFile )
  {
    LanguageFile->setGroup( "General" );
    LanguageFile->writeEntry( "Name", Name, true, false, true );
  }
}


void VLanguageFile::writeTypInfoList( VTypInfoList &List )
{
  if( LanguageFile )
  {
    // get all former types
    QStrList FileList;
    LanguageFile->readListEntry( "Types", FileList );
    
    QStrList NameList;
    
    VTypInfo *TypInfo;
    for( TypInfo=List.first(); TypInfo; TypInfo=List.next() )
    {
      NameList.append( TypInfo->name() );
      
      if( FileList.find(TypInfo->name()) != -1 )
        FileList.remove();
      
      LanguageFile->setGroup( "T:"+TypInfo->name() );
      LanguageFile->writeEntry( "Name", TypInfo->name(), true, false, false );
      LanguageFile->writeEntry( "Name", TypInfo->localName(), true, false, true );
      LanguageFile->writeEntry( "Symbol", TypInfo->symbolString(), true, false, false );
    }
    
    // remove all 
    QString LeftTyp;
    for( LeftTyp=FileList.first(); LeftTyp; LeftTyp=FileList.next() )
    {
      LanguageFile->deleteGroup( LeftTyp );
    }

    LanguageFile->setGroup( "General" );
    LanguageFile->writeEntry( "Types", NameList );
  }
}


void VLanguageFile::writeFile()
{
  if( LanguageFile )
  {
    LanguageFile->sync();
  }  
}
  
/*
  // try to read a global application file
  QString GlobalLangConfigName = kde_datadir() + "/dokvok/languages/" + LangName + ".dvlc";
  QFile GlobalLangConfigFile( GlobalLangConfigName );
  
  // try to open it read-only
  bool Success = aGlobalLangConfigFile.open( IO_ReadOnly );
  if( !Success )
	// there is no global lang config file
	  GlobalLangConfigName = "";
  GlobalLangConfigFile.close();


  // now for the local lang config file
  QString ConfigName = KApplication::localkdedir();
  ConfigName += "/share/apps/dokvok/languages/";
  ConfigName += LangName;
  ConfigName += ".dvlc"; //DokVok Language Config

  QFile ConfigFile( ConfigName );

  // We may write to the file
  if ( ! checkAccess(ConfigName.data(), W_OK ) )
    Success = false;
  else {
  // Open the language-specific config file. It will be created if
  // it does not exist yet.
    Success = ConfigFile.open( IO_ReadWrite );
    // Set uid/gid (necessary for SUID programs)
    if ( Success )     
      chown( ConfigFile.name(), getuid(), getgid() );
  }
  if( !Success )
	{
	  // try to open at least read-only
	  Success = ConfigFile.open( IO_ReadOnly );
	  if( !Success )
		{
		  // we didn't succeed to open a local lang config file
		  Config = new KConfig( GlobalLangConfigName );
		  ConfigState = APPCONFIG_NONE;
		}
	  else
		{
		  // we succeeded to open an app-config file read-only
		  Config = new KConfig( GlobalLangConfigName, ConfigName );
		  ConfigState = APPCONFIG_READONLY;
		}
	}
  else
	{
	  // we succeeded to open an app-config file read-write
	  Config = new KConfig( GlobalLangConfigName, ConfigName );
	  ConfigState = APPCONFIG_READWRITE;
	}

void KApplication::readSettings()
{
  // use the global config files
  KConfig* config = getConfig();
  config->reparseConfiguration();

  QString str;
	
  // Read the color scheme group from config file
  // If unavailable set color scheme to KDE default

  config->setGroup( "General");
  // this default is Qt black
  textColor = config->readColorEntry( "foreground", &black );

  // this default is the Qt lightGray
  backgroundColor = config->readColorEntry( "background", &lightGray  );

  // this default is Qt darkBlue
  selectColor = config->readColorEntry( "selectBackground", &darkBlue );

  // this default is Qt white
  selectTextColor = config->readColorEntry( "selectForeground", &white);

  // this default is Qt white
  windowColor = config->readColorEntry( "windowBackground", &white );

  // this default is Qt black
  windowTextColor = config->readColorEntry( "windowForeground", &black );
	
  config->setGroup( "WM");
  // this default is Qt lightGray
  inactiveTitleColor = config->readColorEntry( "inactiveBackground", &lightGray );

  // this default is Qt darkGrey
  inactiveTextColor = config->readColorEntry( "inactiveForeground", &darkGray );

  // this default is Qt darkBlue
  activeTitleColor = config->readColorEntry( "activeBackground", &darkBlue );

  // this default is Qt white
  activeTextColor = config->readColorEntry( "activeForeground", &white );

  config->setGroup( "KDE");
  contrast = config->readNumEntry( "contrast", 7 );

  //  Read the font specification from config.
  //  Initialize fonts to default first or it won't work !!
		
  pCharsets->setDefault(klocale->charset());
  generalFont = QFont("helvetica", 12, QFont::Normal);
  pCharsets->setQFont(generalFont);
  fixedFont = QFont("fixed", 12, QFont::Normal);
  pCharsets->setQFont(fixedFont);

  config->setGroup( "General" );
  generalFont = config->readFontEntry( "font", &generalFont );
  fixedFont = config->readFontEntry( "fixedFont", &fixedFont );

  // Finally, read GUI style from config.
	
  config->setGroup( "KDE" );
  if ( config->readEntry( "widgetStyle", "Windows 95" ) == "Windows 95" )
    applicationStyle=WindowsStyle;
  else
    applicationStyle=MotifStyle;
	
}
  */