/***************************************************************************
                          LessonInputDlg.cpp  -  description
                             -------------------
    begin                : Thu Dec 9 1999
    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "LessonInputDlg.h"

#define Inherited LessonInputDlgData

#include "resource.h"

#include "compat_2x.h"

LessonInputDlg::LessonInputDlg
(
        QString  _input,
        QString  _descr,
        QString  _label,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
        if (_descr.isEmpty() )
          _descr = i18n("lesson");

        title_label->setText (_label);
        QString format = i18n(": Input %s description");
        QString msg;
#ifndef EA_QT2x
        msg.resize (_descr.length()+format.length());
#endif
        msg.sprintf ((const char*) format,
                     (const char*) _descr);
        setCaption (QString(KVOCTRAIN_TITLE) +msg);

        input = _input;
        e_title->setText (input);
#ifdef EA_QT2x
	connect( e_title, SIGNAL(textChanged(const QString&)), SLOT(slotInputChanged(const QString&)) );
#else
	connect( e_title, SIGNAL(textChanged(const char*)), SLOT(slotInputChanged(const char*)) );
#endif
   	e_title->setFocus();
	e_title->selectAll();
        setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


LessonInputDlg::~LessonInputDlg()
{
}


void LessonInputDlg::slotInputChanged(EA_QTSTR s)
{
  input = s;
}
