/***************************************************************************
                   kva_header.cpp  - header buttons part of kvoctrain
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/************x***************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#define SORT_COLUMN i18n("&Sort column")

#ifdef __ONLY_TO_BE_SEEN_BY_XGETTEXT
   SORT_COLUMN
#else

#include "kvoctrain.h"
#include "compat_2x.h"
#include "query-dialogs/QueryDlgBase.h"

#include <kpopmenu.h>


void kvoctrainApp::slotHeaderMenu(int header) /*FOLD00*/
{
  delete header_m;
  header_m = 0;

  if (header == KV_COL_LESS) {
    header_m = new KPopupMenu(i18n("Lesson menu"));
    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/sort.xpm")), SORT_COLUMN, (header << 16) | IDH_SORT_COL);

    connect (header_m, SIGNAL(activated(int)), this, SLOT(slotHeaderCallBack(int)));
    connect (header_m, SIGNAL(highlighted(int)), this, SLOT(slotHeaderStatus(int)));
    header_m->exec(QCursor::pos());

    return;
  }

  header -= KV_EXTRA_COLS; // adjust doc == header button

  vector<QString> names;
  QString curr_lang;
  QString id = header == 0 ? doc->getOriginalIdent()
                           : doc->getIdent(header);
  if (langset.indexShortId(id) >= 0)
    curr_lang = langset.longId(langset.indexShortId(id));

  // select one of the available languages for the column
  QPopupMenu *langs_m = new QPopupMenu();
  // hack: ID => header-id + language
  for (int i = 0; i < (int) langset.size(); i++) {
    if(langset.longId(i).isEmpty() )
      names.push_back(langset.shortId(i));
    else
      names.push_back(langset.longId(i));
  }

  int accel;
  for (int i = 0; i < (int) names.size(); i++) {
    if (RowTable::createMenuNames("", names, i, accel))
      names[i].insert (accel, "&");
  }

  for (int i = 0; i < (int) langset.size(); i++) {
    if(   !langset.PixMapFile(i).isEmpty()
       && !langset.longId(i).isEmpty() )
      langs_m->insertItem(QPixmap(langset.PixMapFile(i)), names[i],
        (header << 16) | (i << (16+8)) | IDH_SET_LANG);
    else
      langs_m->insertItem(names[i],
        (header << 16) | (i << (16+8)) | IDH_SET_LANG);
  }
  connect (langs_m, SIGNAL(activated(int)), this, SLOT(slotSetHeaderProp(int)));
  connect (langs_m, SIGNAL(highlighted(int)), this, SLOT(slotHeaderStatus(int)));

  header_m = new KPopupMenu(i18n("Column menu for ")+curr_lang);
  header_m->insertSeparator();

  if (header != KV_COL_ORG - KV_EXTRA_COLS ) {
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Create random &query"), (header << 16) | IDH_START_QUERY);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Create &multiple choice"), (header << 16) | IDH_START_MULTIPLE);
    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Train &verbs"), (header << 16) | IDH_START_VERB);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("&Article training"), (header << 16) | IDH_START_ARTICLE);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("&Comparison training"), (header << 16) | IDH_START_ADJECTIVE);
    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/sort.xpm")), SORT_COLUMN, (header << 16) | IDH_SORT_COL);
    if (langset.size() != 0) {
      header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/flags.xpm")), i18n("Set &language"), langs_m, (2 << 16) | IDH_NULL);
    }
    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/reset.xpm")), i18n("Reset &grades"), (header << 16) | IDH_RESET_GRADE);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/delete-col.xpm")), i18n("&Remove column"), (header << 16) | IDH_REMOVE );
  }
  else {
    QPopupMenu *query_m =  new QPopupMenu();
    QPopupMenu *multiple_m =  new QPopupMenu();

    names.clear();
    for (int j = 1; j < (int) doc->numLangs(); j++) {
     int i;
     if ((i = langset.indexShortId(doc->getIdent(j))) >= 0)
       names.push_back(langset.longId(i));
     else
       names.push_back(doc->getIdent(j));
    }

    int accel;
    for (int i = 0; i < (int) names.size(); i++) {
      if (RowTable::createMenuNames("", names, i, accel)) {
        names[i].insert (accel, "&");
      }
    }

    for (int i = 1; i < (int) doc->numLangs(); i++) {
      // show pixmap and long name if available
      int j;
      if((j = langset.indexShortId(doc->getIdent(i))) >= 0
         && !langset.PixMapFile(j).isEmpty()
         && !langset.longId(j).isEmpty() ) {
        query_m->insertItem(QPixmap(langset.PixMapFile(j)), names[i-1],
            (i << (16+8)) |  IDH_START_QUERY);  // hack: IDs => header-ids + cmd
      }
      else {
        query_m->insertItem(doc->getIdent(i), (i << (16+8)) |  IDH_START_QUERY);
      }
    }
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Create random &query"), query_m, (3 << 16) | IDH_NULL);
    connect (query_m, SIGNAL(activated(int)), this, SLOT(slotHeaderCallBack(int)));
    connect (query_m, SIGNAL(highlighted(int)), this, SLOT(slotHeaderStatus(int)));
    for (int i = 1; i < (int) doc->numLangs(); i++) {
      // show pixmap and long name if available
      int j;
      if((j = langset.indexShortId(doc->getIdent(i))) >= 0
         && !langset.PixMapFile(j).isEmpty()
         && !langset.longId(j).isEmpty() ) {
        multiple_m->insertItem(QPixmap(langset.PixMapFile(j)), names[i-1],
            (i << (16+8)) |  IDH_START_MULTIPLE);  // hack: IDs => header-ids + cmd
      }
      else {
        multiple_m->insertItem(doc->getIdent(i), (i << (16+8)) |  IDH_START_MULTIPLE);
      }
    }
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Create &multiple choice"), multiple_m, (4 << 16) | IDH_NULL);
    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("Train &verbs"), (header << 16) | IDH_START_VERB);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("&Article training"), (header << 16) | IDH_START_ARTICLE);
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/run.xpm")), i18n("&Comparison training"), (header << 16) | IDH_START_ADJECTIVE);
    connect (multiple_m, SIGNAL(activated(int)), this, SLOT(slotHeaderCallBack(int)));
    connect (multiple_m, SIGNAL(highlighted(int)), this, SLOT(slotHeaderStatus(int)));

    header_m->insertSeparator();
    header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/sort.xpm")), SORT_COLUMN, (header << 16) | IDH_SORT_COL);

    if (langset.size() != 0) {
      header_m->insertItem(QPixmap(EA_KDEDATADIR("", "kvoctrain/flags.xpm")), i18n("Set &language"), langs_m, (2 << 16) | IDH_NULL);
    }
  }

  connect (header_m, SIGNAL(activated(int)), this, SLOT(slotHeaderCallBack(int)));
  connect (header_m, SIGNAL(highlighted(int)), this, SLOT(slotHeaderStatus(int)));
  header_m->exec(QCursor::pos());
}


# ifdef SHP_BUG
static void _shp_bug_setIdent (kvoctrainDoc *doc, /*FOLD00*/
                               int header1, const QString id)
{
  cout << (void*) doc << " " << header1 << " " << id << endl;
  cout << "det: " << doc->getIdent(header1) << endl;

  if (header1 > 0)
    doc->setIdent(header1, id);
  else
    doc->setOriginalIdent(id);
  cout << (void*) doc << " " << header1 << " " << id << endl;
}
#endif

void kvoctrainApp::slotSetHeaderProp (int header_and_id) /*FOLD00*/
{
  int header1 = (header_and_id >> 16) & 0xFF;  // org, trans1, trans2, ..
  int id = header_and_id >> (16+8);            // language ident
//int cmd  = header_and_id & 0xFFFF;           // always SET_LANG

  if (id >= (int) langset.size())
    return; // ???

  QString lid = langset.shortId(id);
  if  (!langset.longId(id).isEmpty() )
    lid = langset.longId(id);

  QString pm = "";
  if (!langset.PixMapFile(id).isEmpty() )
    pm = langset.PixMapFile(id);

  view->setHeaderProp (header1+KV_EXTRA_COLS, lid, pm);

  cout << "shp 1: " << (void*) doc << endl << flush;
  for (int i = 0; i < (int) langset.size(); i++) {
     cout << " " <<  langset.shortId(i) << "  "
          << langset.longId(i)  << "  "
          << langset.PixMapFile(i) << "  "
          << hex << (const void*) langset.PixMapFile(i) << endl;
  }

# ifdef SHP_BUG
  _shp_bug_setIdent (doc, header1, langset.shortId(id));
#else
  if (header1 > 0)
    doc->setIdent(header1, id);
  else
    doc->setOriginalIdent(id);
#endif

  for (int i = 0; i < (int) langset.size(); i++) {
     cout << " " <<  langset.shortId(i) << "  "
          << langset.longId(i)  << "  "
          << langset.PixMapFile(i) << "  "
          << hex << (const void*) langset.PixMapFile(i) << endl;
  }

  doc->setModified();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotHeaderStatus (int header_and_cmd) /*FOLD00*/
{
  int header1 = (header_and_cmd >> 16) & 0xFF;
  int header2 = header_and_cmd >> (16+8);
  int cmd     = header_and_cmd & 0xFFFF;

//cout << "h1 " << header1 << " h2 " << header2 << " cmd " << cmd << endl;

  switch (cmd) {
    case IDH_NULL:
    break;

    case IDH_SORT_COL:
        slotStatusHelpMsg(i18n("Sorts column alphabetically up/down"));
    break;

    case IDH_SET_LANG: {
      QString from = langset.longId(header2);
      if (from.isEmpty())
        from = langset.shortId(header2);

      QString msg;
      if (header1 == 0) {
        QString format = i18n("Sets %s as language for original");
#ifndef EA_QT2x
        msg.resize (from.length()+format.length());
#endif
        msg.sprintf ((const char*) format,
                     (const char*) from);
      }
      else {
        QString format = i18n("Sets %s as language for translation %s");
        QString num;
        num.setNum (header1);
#ifndef EA_QT2x
        msg.resize (num.length()+from.length()+format.length());
#endif
        msg.sprintf ((const char*) format,
                     (const char*) from,
                     (const char*) num);
      }
      slotStatusHelpMsg(i18n(msg));
    }
    break;

    case IDH_REMOVE: {
      QString format = i18n("Removes %s irrevocably from dictionary");
      QString from = header1 ? doc->getIdent(header1) : doc->getOriginalIdent();
      if (!langset.findLongId(from).isEmpty())
        from = langset.findLongId(from);
      QString msg;
#ifndef EA_QT2x
      msg.resize (from.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) from);
      slotStatusHelpMsg(i18n(msg));
    }
    break;

    case IDH_START_QUERY:
    case IDH_START_MULTIPLE: {
      QString to = header1 ? doc->getIdent(header1) : doc->getOriginalIdent();
      if (!langset.findLongId(to).isEmpty())
        to = langset.findLongId(to);

      QString from = header2 ? doc->getIdent(header2) : doc->getOriginalIdent();
      if (!langset.findLongId(from).isEmpty())
        from = langset.findLongId(from);

      QString format;
      if (cmd == IDH_START_QUERY)
        format = i18n("Creates and starts query from %s to %s");
      else
        format = i18n("Creates and starts multiple choice from %s to %s");

      QString msg;
#ifndef EA_QT2x
      msg.resize (from.length()+to.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) from,
                   (const char*) to);
      slotStatusHelpMsg(i18n(msg));
    }
    break;

    case IDH_START_VERB: {
        slotStatusHelpMsg(i18n("Starts training with verbs"));
    }
    break;

    case IDH_START_ARTICLE: {
        slotStatusHelpMsg(i18n("Starts articles training"));
    }
    break;

    case IDH_START_ADJECTIVE: {
        slotStatusHelpMsg(i18n("Starts training with adjectives"));
    }
    break;

    case IDH_CREATE_LESSON: {
        slotStatusHelpMsg(i18n("Creates lesson"));
    }
    break;

    case IDH_RESET_GRADE: {
      QString from = header1 ? doc->getIdent(header1) : doc->getOriginalIdent();
      if (!langset.findLongId(from).isEmpty())
        from = langset.findLongId(from);
      QString format = i18n("Resets all properties for %s");
      QString msg;
#ifndef EA_QT2x
      msg.resize (from.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) from);
      slotStatusHelpMsg(i18n(msg));
    }
    break;

    default:
      cerr << "kvoctrainApp::slotHeaderStatus: got unknown command :" << cmd << endl;
  }
}


void kvoctrainApp::slotHeaderCallBack (int header_and_cmd) /*FOLD00*/
{
  int header1 = (header_and_cmd >> 16) & 0xFF;
  int header2 = header_and_cmd >> (16+8);
  int cmd     = header_and_cmd & 0xFFFF;

  if (header1 >= (int) doc->numLangs())
    return;

  if (header2 >= (int) doc->numLangs())
    return;

  switch (cmd) {
    case IDH_NULL:
    break;

    case IDH_SORT_COL:
      view->getTable()->sortByColumn(header1);
    break;

    case IDH_REMOVE: {
      QString msg;
      QString name;

      name = doc->getIdent(header1);
      int i= langset.indexShortId(name);
      if ( i >= 0
          && !langset.longId(i).isEmpty() )
        name = langset.longId(i);

      QString format = i18n("You are about to delete a language completely\n\n"
                            "Do you really want to delete \"%s\" ?");
#ifndef EA_QT2x
      msg.resize (name.length()+format.length());
#endif
      msg.sprintf ((const char*) format,
                   (const char*) name);
#ifdef EA_KDE2x
      int exit = KMessageBox::warningYesNo(this, KVOCTRAIN_TITLE, msg);
      if(exit==KMessageBox::Yes) {
#else
      int exit = KMsgBox::yesNo(this, KVOCTRAIN_TITLE,
                 msg,
                 KMsgBox::DB_SECOND | KMsgBox::EXCLAMATION);
  
      if(exit==1) {
#endif
        doc->removeIdent(header1);
        view->setView (doc, langset, gradecols);
        doc->setModified();
      }
    }
    break;

    case IDH_START_QUERY:
      delete queryDlg;
      queryDlg = 0;
      queryType = QT_Random;
      slotStartQuery(header1 ? doc->getIdent(header1) : doc->getOriginalIdent(),
                     header2 ? doc->getIdent(header2) : doc->getOriginalIdent());
    break;

    case IDH_START_MULTIPLE:
      delete queryDlg;
      queryDlg = 0;
      queryType = QT_Multiple;
      slotStartQuery(header1 ? doc->getIdent(header1) : doc->getOriginalIdent(),
                     header2 ? doc->getIdent(header2) : doc->getOriginalIdent());
    break;

    case IDH_START_VERB: {
      slotStartSpecial (header1, QM_VERB);
      delete queryDlg;
      queryDlg = 0;
      queryType = QT_Conjugation;
    }
    break;

    case IDH_START_ARTICLE: {
      delete queryDlg;
      queryDlg = 0;
      queryType = QT_Articles;
      slotStartSpecial (header1, QM_NOUN);
    }
    break;

    case IDH_START_ADJECTIVE: {
      delete queryDlg;
      queryDlg = 0;
      queryType = QT_Comparison;
      slotStartSpecial (header1, QM_ADJ);
    }
    break;

    case IDH_CREATE_LESSON:
      slotCreateLesson(header1);
    break;

    case IDH_RESET_GRADE: {
      QString msg;
      QString name;
      QString format;

      if (act_lesson == 0) {
        name = doc->getIdent(header1);
        int i = langset.indexShortId(doc->getIdent(header1));
        if (i >= 0
            && !langset.longId(i).isEmpty() )
          name = langset.longId(i);
        format = i18n("You are about to reset the knowledge data of a "
                      "whole language\n\nDo you really want to reset \"%s\" ?");
      }
      else {
        name = lessons->text(act_lesson);
        format = i18n("You are about to reset the knowledge data of a "
                      "lesson\n\nDo you really want to reset \"%s\" ?");
      }

#ifndef EA_QT2x
      msg.resize (name.length()+format.length());
#endif
      msg.sprintf ((const char*) format ,
                   (const char*) name);
#ifdef EA_KDE2x
      int exit = KMessageBox::warningYesNo(this, KVOCTRAIN_TITLE, msg);
      if(exit==KMessageBox::Yes) {
#else
      int exit = KMsgBox::yesNo(this, KVOCTRAIN_TITLE,
                msg,
                KMsgBox::DB_SECOND | KMsgBox::EXCLAMATION);
      if(exit==1) {
#endif
        doc->resetEntry (header1, act_lesson);
        doc->setModified();
        view->getTable()->updateViewPort();
        view->getTable()->repaintCells();
      }
    }
    break;

    default:
      cerr << "kvoctrainApp::slotHeaderCallBack: got unknown command\n";

  }
  slotStatusMsg(IDS_DEFAULT);
}

#endif __ONLY_TO_BE_SEEN_BY_XGETTEXT
