/***************************************************************************
                   kvoctrain.cpp  - main part of kvoctrain
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <klined.h>
#include <kapp.h>
#include <qtimer.h>
#include <qfile.h>
#include <qtooltip.h>
#include <qprogressbar.h>

#include "compat_2x.h"
#include "eadebug.h"
#include "kvoctraindoc.h"
#include "langset.h"
#include "kvoctrain.h"
#include "entry-dialogs/EntryDlg.h"
#include "option-dialogs/GeneralOptionsDlg.h"
#include "docprop-dialogs/DocPropDlg.h"
#include "common-dialogs/ProgressDlg.h"
#include "statistik-dialogs/StatistikDlg.h"
#include "common-dialogs/aboutdialog.h"

void kvoctrainApp::slotSaveOptions() /*FOLD00*/
{
   saveOptions(true);
}


kvoctrainApp::~kvoctrainApp() /*FOLD00*/
{
   delete header_m;
   delete qtimer;
   delete btimer;
   delete view;
   delete doc;
}


void kvoctrainApp::slotCancelSelection () /*FOLD00*/
{
  if (tagCount != 0) {
    for (int i = 0; i < doc->numEntries(); i++)
      doc->getEntry(i)->setTagged(false);
    view->getTable()->repaintCells();
  }
  tagCount = 0;
  tagLastRow = -1;
  tagLastCol = -1;
}


void kvoctrainApp::slotSelectAll () /*FOLD00*/
{
  for (int i = 0; i < doc->numEntries(); i++)
    doc->getEntry(i)->setTagged(true);
  view->getTable()->repaintCells();
  tagCount = doc->numEntries();
  tagLastRow = -1;
  tagLastCol = -1;
}


void kvoctrainApp::slotCellMoved(int row, int col, int keys) /*FOLD00*/
{
  col -= KV_EXTRA_COLS;

  if (  doc->numEntries() <= row
      ||doc->numLangs() <= col
      || row < 0
      || col < 0) {
    rem_label->setText  (i18n (PREFIX_Remark));
    pron_label->setText (i18n (PREFIX_Pronunce));
    type_label->setText (i18n (PREFIX_Type));
    return;
  }

  kvoctrainExpr *expr = doc->getEntry(row);

  rem_label->setText (QString(i18n  (PREFIX_Remark))+expr->getRemark (col));
  pron_label->setText (QString(i18n (PREFIX_Pronunce))+expr->getPronunce (col));
  type_label->setText (QString(i18n (PREFIX_Type))
            +QueryManager::typeStr(expr->getType (col)));
}


void kvoctrainApp::slotTagEntry(int row, int col, int key) /*FOLD00*/
{
  controlActive = (key & ControlButton) != 0;
  shiftActive = (key & ShiftButton) != 0;
  altActive = (key & AltButton) != 0;

  if (   doc == 0
      || view == 0
      || view->getTable() == 0
      || view->getTable()->numRows() <= 0
      || row < 0
      || col < 0)
    return;

  slotCellMoved (row, col, key);
  if (shiftActive) {
    int first, last;

    if (tagLastRow < 0 || tagLastCol < 0) {
      first = row;
      last = row;
    }
    else if (row > tagLastRow) {
      first = tagLastRow;  // +1
      last = row;
    }
    else {
      first = row;
      last = tagLastRow;  // -1
    }
    bool tag;
    for (int i = first; i <= last; i++) {
      if (controlActive) {
        doc->getEntry(i)->setTagged ((tag = !doc->getEntry(i)->isTagged ()));
        if (tag)
          tagCount ++;
        else
          tagCount --;
      }
      else {
        if (!doc->getEntry(i)->isTagged()) {
          tagCount++;
          doc->getEntry(i)->setTagged(true);
        }
      }
    }
    view->getTable()->repaintCells(first, last);
    tagLastRow = row;
    tagLastCol = col;
  }
  else if (controlActive) {
    bool tag;
    doc->getEntry(row)->setTagged ((tag = !doc->getEntry(row)->isTagged ()));
    if (tag)
      tagCount ++;
    else
      tagCount --;

    tagLastRow = row;
    tagLastCol = col;

    // update current row with all cols
    for (int i = 0; i < view->getTable()->numCols(); i++)
      view->getTable()->updateCell(view->getTable()->currentRow(), i);

  }
  else if (altActive) {
    // keep selection
  }
  else {

    slotCancelSelection ();
    tagLastRow = row;
    tagLastCol = col;
  }
}


void kvoctrainApp::slotSelectEntry (int row, int col, int key_state) /*FOLD00*/
{
   if (view->getTable()->numRows() <= 0
       || row < 0
       || col < 0)
     return;

   if (key_state != 0) { // some shift/ctrl key
     if (doc->getEntry(row)->getLesson () == 0)
       doc->getEntry(row)->setLesson (act_lesson);
     else
       doc->getEntry(row)->setLesson (0);
   }
   else
     doc->getEntry(row)->setSelected (!doc->getEntry(row)->isSelected());

   doc->setModified(true);
   // update current row with all cols
   for (int i = 0; i < view->getTable()->numCols(); i++)
     view->getTable()->updateCell(view->getTable()->currentRow(), i);
}


void kvoctrainApp::slotEditRow() /*FOLD00*/
{
  slotEditEntry (view->getTable()->currentRow(),
             view->getTable()->currentCol());
}


bool kvoctrainApp::slotEditEntry (int row, int col) /*FOLD00*/
{
   QString s1,
           s2,
           expr,
           lang;

   if (col == KV_COL_LESS
       || row < 0
       || col < 0)
     return false;

   col -= KV_EXTRA_COLS;

   if (view->getTable()->numRows() <= 0)
     return false;

   s1.setNum(row);
   s2.setNum(col);

   if (col == 0) {
     lang = doc->getOriginalIdent();
     expr = doc->getEntry(row)->getOriginal();
   }
   else {
     lang = doc->getIdent(col);
     expr = doc->getEntry(row)->getTranslation(col);
   }

   int lesson = doc->getEntry(row)->getLesson();
   if (lesson >= lessons->count())
     lesson = QMAX (0, lessons->count()-1);

   QString title;
   if (col == 0)
     title = i18n("Edit properties for original");
   else
     title = i18n("Edit properties of translation");

   EntryDlg edlg (doc,
                  tagCount != 0,
                  col==0,
                  doc->getEntry(row)->getGrade(col, false),
                  doc->getEntry(row)->getGrade(col, true),
                  doc->getEntry(row)->getQueryCount(col, false),
                  doc->getEntry(row)->getQueryCount(col, true),
                  doc->getEntry(row)->getBadCount(col, false),
                  doc->getEntry(row)->getBadCount(col, true),
                  doc->getEntry(row)->getQueryDate(col, false),
                  doc->getEntry(row)->getQueryDate(col, true),
                  doc->getEntry(row)->getFauxAmi(col, false),
                  doc->getEntry(row)->getFauxAmi(col, true),
                  expr,
                  lesson,
                  lessons,
                  lang,
                  langset,
                  doc->getEntry(row)->getRemark(col),
                  doc->getEntry(row)->getType(col),
                  doc->getEntry(row)->getPronunce(col),
                  doc->getEntry(row)->getSynonym(col),
                  doc->getEntry(row)->getAntonym(col),
                  doc->getEntry(row)->getExample(col),
                  doc->getConjugation(col),
                  doc->getEntry(row)->getConjugation(col),
                  doc->getArticle(col),
                  doc->getEntry(row)->getComparison(col),
                  0, title);

//   edlg.initFocus();
   int res = edlg.exec();

   if (res == QDialog::Accepted) {

     fillLessonBox(doc);
     kvoctrainExpr *expr = doc->getEntry(row);

     if (tagCount == 0) {
       if (col == 0)
         expr->setOriginal(edlg.getExpr());
       else
         expr->setTranslation(col, edlg.getExpr());

     // do the same for "append entry"

       expr->setRemark (col, edlg.getRemark());
       expr->setPronunce (col, edlg.getPronunce());

       expr->setSynonym (col, edlg.getSynonym());
       expr->setAntonym (col, edlg.getAntonym());
       expr->setExample (col, edlg.getExample());
       expr->setConjugation (col, edlg.getConjugation());
       expr->setComparison(col, edlg.getComparison() );

       expr->setFauxAmi (col, edlg.getFromFauxAmi(), false);
       expr->setFauxAmi (col, edlg.getToFauxAmi(), true);
       expr->setGrade(col, edlg.getFromGrade(), false);
       expr->setGrade(col, edlg.getToGrade(), true);
       expr->setQueryCount(col, edlg.getFromQCount(), false);
       expr->setQueryCount(col, edlg.getToQCount(), true);
       expr->setBadCount(col, edlg.getFromBCount(), false);
       expr->setBadCount(col, edlg.getToBCount(), true);
       expr->setQueryDate(col, edlg.getFromDate(), false);
       expr->setQueryDate(col, edlg.getToDate(), true);
       expr->setLesson (edlg.getLesson());
       expr->setType (col, edlg.getType());

       for (int i = 0; i <= expr->numTranslations(); i++)
         if (expr->getType(i).isEmpty() )
           expr->setType(i, edlg.getType());

       for (int i = 0; i <= expr->numTranslations(); i++)
         if (QueryManager::getMainType(expr->getType(i))
             !=
             QueryManager::getMainType(edlg.getType()) )
           expr->setType(i, edlg.getType());
     }
     else {
       for (int i = 0; i < doc->numEntries(); i++) {
         kvoctrainExpr *expr = doc->getEntry(i);
         if (expr->isTagged()) {
           // only updated "common" props in multimode
           if (edlg.fromGradeDirty() )
             expr->setGrade(col, edlg.getFromGrade(), false);
           if (edlg.toGradeDirty() )
             expr->setGrade(col, edlg.getToGrade(), true);
  
           if (edlg.fromQCountDirty() )
             expr->setQueryCount(col, edlg.getFromQCount(), false);
           if (edlg.toQCountDirty() )
             expr->setQueryCount(col, edlg.getToQCount(), true);
  
           if (edlg.fromBCountDirty() )
             expr->setBadCount(col, edlg.getFromBCount(), false);
           if (edlg.toBCountDirty() )
             expr->setBadCount(col, edlg.getToBCount(), true);
  
           if (edlg.fromDateDirty() )
             expr->setQueryDate(col, edlg.getFromDate(), false);
           if (edlg.toDateDirty() )
             expr->setQueryDate(col, edlg.getToDate(), true);
  
           if (edlg.lessonDirty() )
             expr->setLesson (edlg.getLesson());

           if (edlg.typeDirty() ) {
             for (int i = 0; i <= expr->numTranslations(); i++)
               expr->setType(i, edlg.getType());
           }
         }
       }
     }

     doc->setModified(true);
     // update current row with all cols
     for (int i = 0; i < view->getTable()->numCols(); i++)
       view->getTable()->updateCell(row, i);

      slotCellMoved(view->getTable()->currentRow(),
                    view->getTable()->currentCol(),
                    -1);
   }
   return res == QDialog::Accepted;
}


void kvoctrainApp::slotDocProps () /*FOLD00*/
{
   qtimer->stop();
   int old_lessons = (int) lessons->count();
   int old_types = (int) doc->getTypeDescr().size();

   DocPropsDlg ddlg (doc,
                     0,
                     lessons,
                     doc->getTitle(),
                     doc->getAuthor(),
                     doc->getTypeDescr(),
                     &langset);

   int res = ddlg.exec();

   if (res == QDialog::Accepted) {
      vector<int> typeIndex;
      vector<int> lessonIndex;
      vector<QString> new_typeStr;
      vector<QString> new_lessonStr;

      doc->allowSorting(ddlg.getSorting() );

      doc->setTitle(ddlg.getTitle() );
      doc->setAuthor(ddlg.getAuthor() );
      for (int i = 0; i < doc->numLangs(); i++) {
        doc->setArticle(i, ddlg.getArticle(i) );
        doc->setConjugation(i, ddlg.getConjugation(i) );
      }

/*
      for (int i = 0; i < doc->numLangs(); i++) {

        int idx = ddlg.getLangCode(i);
        if (i == 0)
          doc->setOriginalIdent(langset.shortId(idx));
        else
          doc->setIdent(i, langset.shortId(idx));

        QString lid = langset.shortId(idx);
        if  (!langset.longId(idx).isEmpty() )
          lid = langset.longId(idx);

        QString pm = "";
        if (!langset.PixMapFile(idx).isEmpty() )
          pm = langset.PixMapFile(idx);

        view->setHeaderProp (i+KV_EXTRA_COLS, lid, 0, pm);

      }
*/
      slotStatusMsg(i18n("updating lesson indices..."));
      QApplication::setOverrideCursor( waitCursor );

      ddlg.getLesson(lessons, lessonIndex);
      ddlg.getTypeNames(new_typeStr, typeIndex);

      LessOptPage::cleanUnused(doc, lessons, lessonIndex, old_lessons);
      for (int i = 1; i < lessons->count(); i++)
        new_lessonStr.push_back(lessons->text(i));

      slotStatusMsg(i18n("updating types indices..."));
      TypeOptPage::cleanUnused(doc, typeIndex, old_types);
      QueryManager::setTypeNames (new_typeStr);

      doc->setTypeDescr (new_typeStr);
      doc->setLessonDescr (new_lessonStr);
      doc->setModified();
      view->getTable()->repaintCells();

      setCaption(QString(KVOCTRAIN_TITLE) + ": " + doc->getTitle());
      doc->setModified();

      QApplication::restoreOverrideCursor();
      slotStatusMsg(IDS_DEFAULT);
   }

   if (querymode && !querying)
     qtimer->start(0, TRUE);
}


void kvoctrainApp::slotRemoveRow() /*FOLD00*/
{
  if (tagCount == 0) {
#ifdef EA_KDE2x
    if( KMessageBox::Yes == KMessageBox::questionYesNo(this, KVOCTRAIN_TITLE,
                  i18n("Do you really want to delete the selected entry ?\n"))) {
#else
    if( 1 == KMsgBox::yesNo(this, KVOCTRAIN_TITLE,
                  i18n("Do you really want to delete the selected entry ?\n"),
                  KMsgBox::QUESTION | KMsgBox::DB_SECOND)) {
#endif
      view->getTable()->removeCurrentItem ();
      view->getTable()->updateViewPort();
      view->getTable()->repaintCells();
    }
  }
  else {
#ifdef EA_KDE2x
    if( KMessageBox::Yes == KMessageBox::questionYesNo(this, KVOCTRAIN_TITLE,
                  i18n("Do you really want to delete the selected range ?\n"))) {
#else
    if( 1 == KMsgBox::yesNo(this, KVOCTRAIN_TITLE,
                  i18n("Do you really want to delete the selected range ?\n"),
                  KMsgBox::QUESTION | KMsgBox::DB_SECOND)) {
#endif
      for (int i = doc->numEntries()-1; i >= 0; i--)
        if (doc->getEntry(i)->isTagged() )
          doc->removeEntry(i);
      view->getTable()->updateViewPort();
      view->getTable()->repaintCells();
    }
  }
}


void kvoctrainApp::slotAppendRow () /*FOLD00*/
{
  int res;
  do {
    EntryDlg edlg (doc,
                   false, true,
                   0,
                   0,
                   0,
                   0,
                   0,
                   0,
                   0,
                   0,
                   "",
                   "",
                   "",
                   act_lesson,
                   lessons,
                   doc->getOriginalIdent(),
                   langset,
                   "",
                   0,
                   "",
                   "",
                   "",
                   0,
                   doc->getConjugation(0),
                   Conjugation(),
                   doc->getArticle(0),
                   Comparison(),
                   0,
                   i18n("Enter new original expression")
                   );
    res = edlg.exec();
    if (res == QDialog::Accepted) {
      fillLessonBox(doc);
      kvoctrainExpr expr (edlg.getExpr(), edlg.getLesson());
      expr.setRemark (0, edlg.getRemark());
      expr.setType (0, edlg.getType());
      expr.setPronunce (0, edlg.getPronunce());
      expr.setSynonym (0, edlg.getSynonym());
      expr.setAntonym (0, edlg.getAntonym());
      expr.setExample (0, edlg.getExample());
      expr.setConjugation (0, edlg.getConjugation());
      expr.setComparison(0, edlg.getComparison() );
      expr.setLesson (edlg.getLesson());
      expr.setType (0, edlg.getType());
  
      view->getTable()->appendItem (&expr);
      int row = view->getTable()->numRows()-1;
      view->getTable()->setCurrentRow (row, KV_COL_ORG);
      view->getTable()->updateViewPort();
      slotCellMoved(view->getTable()->currentRow(),
                    view->getTable()->currentCol(),
                    0);
      for (int i = 1; i <= doc->numLangs(); i++)
         expr.setType (i, edlg.getType());
  
      // enter all new translations
      if (smartAppend) {
        slotChooseLesson(edlg.getLesson());
  
        bool nextcol = smartAppend;
        for (int i = 2; nextcol && i <= doc->numLangs(); i++) {
          if ((nextcol = slotEditEntry (row, i))) {
            int lesson = doc->getEntry(row)->getLesson();
            if (lesson >= lessons->count())
              lesson = QMAX (0, lessons->count()-1);
            slotChooseLesson(lesson);
          }
          else
            return;
        }
      }
    }
  } while (res == QDialog::Accepted && smartAppend);
}


void kvoctrainApp::keyReleaseEvent( QKeyEvent *e ) /*FOLD00*/
{
  switch( e->key() ) {
    case Key_Shift:  shiftActive = false;
    break;

    case Key_Alt:  altActive = false;
    break;

    case Key_Control:  controlActive = false;
    break;
  }
}


void kvoctrainApp::keyPressEvent( QKeyEvent *e ) /*FOLD00*/
{
  controlActive = (e->state() & ControlButton) != 0;
  shiftActive = (e->state() & ShiftButton) != 0;
  altActive = (e->state() & AltButton) != 0;

  switch( e->key() ) {
    case Key_Plus:  
      if (controlActive) {
        int less = lessons->currentItem();
        if (less == lessons->count()-1)
          lessons->setCurrentItem(0);
        else
          lessons->setCurrentItem(less+1);
        slotChooseLesson(lessons->currentItem());
      }
    break;

    case Key_Minus:
      if (controlActive) {
        int less = lessons->currentItem();
        if (less == 0)
          lessons->setCurrentItem(lessons->count()-1);
        else
          lessons->setCurrentItem(less-1);
        slotChooseLesson(lessons->currentItem());
      }
    break;

    case Key_Shift:  shiftActive = true;
    break;

    case Key_Alt:  altActive = true;
    break;

    case Key_Control:  controlActive = true;
    break;

    case Key_Tab:
      if (view->getTable()->hasFocus() )  {
        searchLine->setFocus();
        searchLine->selectAll();
      }
      else
        view->getTable()->setFocus();
    break;

    case Key_Backtab:
      if (searchLine->hasFocus() )  
        view->getTable()->setFocus();
      else {
        searchLine->setFocus();
        searchLine->selectAll();
      }
    break;

    case Key_Delete:
      slotRemoveRow();
    break;

    case Key_Insert: {
      slotAppendRow();
    }
    break;
      
    default:
      bool found = false;
      if (/*shiftActive && */ altActive) {
        for (int i = KV_COL_LESS; i < view->getTable()->numCols(); i++)
          if (tolower(e->key()) == view->getHeaderAccel(i)) {
            slotHeaderMenu(i);
            found = true;
          }
      }
      if (!found)
        e->ignore();
  }
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotChooseLesson(int idx) /*FOLD00*/
{
  act_lesson = idx;
  doc->setCurrentLesson(idx);
  doc->setModified(true);
}


void kvoctrainApp::slotCreateLesson(int header) /*FOLD00*/
{
  vector <int> sel;
  doc->setModified();
  for (int i = 0; i < view->getTable()->count(); i++) {
    kvoctrainExpr *kv = view->getTable()->getRow(i);
    kv->setLesson(0);
    if (kv->getGrade(header) > THRESH_LESSON
        && !kv->getTranslation(header).isEmpty() )
      sel.push_back(i);
  }

  int cnt = 0;
  srand((unsigned int)time((time_t *)NULL));
  while (cnt < MAX_LESSON && sel.size() != 0) {
    int nr = (int) (sel.size() * ((1.0*rand())/RAND_MAX));
    kvoctrainExpr *kv = view->getTable()->getRow(sel[nr]);
    // include non-lesson and non-empty string
    if (kv->getLesson() == 0) {
      kv->setLesson(1);
      sel.erase (&sel[nr], &sel[nr+1]);
      cnt++;
    }
  }
  view->getTable()->setCurrentRow(view->getTable()->currentRow(),
                                  view->getTable()->currentCol());
  slotCellMoved(view->getTable()->currentRow(),
                view->getTable()->currentCol(),
                0);
  view->getTable()->updateViewPort();
}


void kvoctrainApp::slotShowStatist() /*FOLD00*/
{
   StatistikDlg sdlg (langset, doc, &gradecols);
   sdlg.exec();
}


void kvoctrainApp::slotCleanVocabulary () /*FOLD00*/
{
   prepareProgressBar();
   QApplication::setOverrideCursor( waitCursor );
   int num = doc->cleanUp();
   QApplication::restoreOverrideCursor();
   removeProgressBar();

   slotStatusMsg(IDS_DEFAULT);

   if (num != 0) {
     view->setView(doc, langset, gradecols);
     view->getTable()->repaintCells();
     if (view->getTable()->currentRow() > doc->numEntries()) {
       view->getTable()->setCurrentRow (doc->numEntries(),
                                        view->getTable()->currentCol());
       slotCellMoved(view->getTable()->currentRow(),
                     view->getTable()->currentCol(),
                     0);
     }
     QString s;
     s.setNum (num);
     s += i18n(" entries with same content have been found and removed");

#ifdef EA_KDE2x
     KMessageBox::information(this, QString(KVOCTRAIN_TITLE) +": " +i18n("Clean up"),
       s);
#else
     KMsgBox::message(this, QString(KVOCTRAIN_TITLE) +": " +i18n("Clean up"),
       s,
       KMsgBox::INFORMATION);
#endif
   }
}


void kvoctrainApp::slotCreateRandom() /*FOLD00*/
{
   slotStatusMsg(i18n("Creating random lessons..."));
   QApplication::setOverrideCursor( waitCursor );

   vector<kvoctrainExpr*> random;
   for (int i = 0; i < doc->numEntries(); i++) {
     kvoctrainExpr *expr = doc->getEntry(i);
     if (expr->getLesson() == 0)
       random.push_back(expr);
   }

   if (random.size () != 0) {
     srand((unsigned int)time((time_t *)NULL));
     int less_no = lessons->count() /* +1 anyway */ ;
     QString s;
     s.setNum (less_no);
     s.insert (0, "- ");
     lessons->insertItem (s);
  // FIXME: make this count variable
     int less_cnt = 50;
     while (random.size () != 0) {
       if (less_cnt-- <= 0) {
  // FIXME: make this count variable
         less_cnt = 50;
         less_no++;
         s.setNum (less_no);
         s.insert (0, "- ");
         lessons->insertItem (s);
       }
       int nr = (int) (random.size() * ((1.0*rand())/RAND_MAX));
       random[nr]->setLesson (less_no);
       random.erase(&random[nr], &random[nr+1]);
     }
  
     vector<QString> new_lessonStr;
     for (int i = 1; i < lessons->count(); i++)
       new_lessonStr.push_back(lessons->text(i));
     doc->setLessonDescr (new_lessonStr);
     view->getTable()->repaintCells();
   }
   QApplication::restoreOverrideCursor();
   slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotGeneralOptions() /*FOLD00*/
{
   qtimer->stop();

   QString defTrans;
   GeneralOptionsDlg godlg (defTrans,
                    separator,
                    backupTime /(60*1000),
                    langset,
                    lastPixName,
                    lessons,
                    paste_order,
                    doc,
                    tablefont,
                    &querymanager,
                    gradecols,
                    header_resizer,
                    smartAppend);

   int res = godlg.exec();
   if (res == QDialog::Accepted) {

      defTrans = godlg.getDefaultLang();
      backupTime = godlg.getBackupTime()*60*1000;
      smartAppend = godlg.getSmartAppend();
      separator = godlg.getSeparator();
      langset = godlg.getLangSet();
      paste_order = godlg.getPasteOrder();
      tablefont = godlg.getFont();
      view->getTable()->setFont(tablefont);
      view->getTable()->updateViewPort();
      gradecols = godlg.getGradeCols();
      header_resizer = godlg.getResizer();

      view->setResizer (header_resizer);
      view->getTable()->repaintCells();
     
      // update header buttons
/*
      for (int i = 0; i < (int) doc->numLangs(); i++) {
        QString sid = i>0 ? doc->getIdent(i)
                          : doc->getOriginalIdent();
 
        int idx = langset.indexShortId(sid);
        QString pm = "";
        QString lid = sid;;
        if  (idx >= 0) {
          lid = langset.longId(idx);
          pm = langset.PixMapFile(idx);
        }
        view->setHeaderProp (i+KV_EXTRA_COLS, lid, 0, pm);
      }
*/
      slotStatusMsg(IDS_DEFAULT);
   }
   if (querymode && !querying)
     qtimer->start(0, TRUE);
}


void kvoctrainApp::slotAppendLang() /*FOLD00*/
{
   view->getTable()->appendCol();
   int newcol = doc->numLangs();
   for (int i = 0; i < (int) doc->numEntries(); i++) {
      kvoctrainExpr *expr = doc->getEntry(i);
      expr->setType (newcol-1, expr->getType(0));
   }
   view->setView(doc, langset, gradecols);
   doc->setModified();
}


void kvoctrainApp::slotInitSearch() /*FOLD00*/
{
  searchpos = 0;
  searchstr = "";
}


void kvoctrainApp::slotSearchNext() /*FOLD00*/
{
  slotResumeSearch(searchstr);
}


void kvoctrainApp::slotResumeSearch(EA_QTSTR s) /*FOLD00*/
{
#ifdef EA_QT2x
  if (s.length() == 0) {
#else
  if (strlen(s) == 0) {
#endif
    slotInitSearch();
    return;
  }

  slotStatusMsg(i18n("Searching expression..."));
  QApplication::setOverrideCursor( waitCursor );

  // new word or shortend word
#ifdef EA_QT2x
  if (s.length() < searchstr.length() )
#else
  if (strlen(s) < searchstr.length() )
#endif
    searchpos = 0;

  // search in current col from current row till end
  // SHIFT means start search from beginning of word
  bool word_beg = shiftActive;
  int idx = doc->search(s, view->getTable()->currentCol()-KV_EXTRA_COLS, searchpos, -1, word_beg, false);
  if (idx >= 0) {
    view->getTable()->setCurrentRow(idx, view->getTable()->currentCol());
    view->getTable()->updateViewPort();
    searchpos = idx+1;
    slotCellMoved(view->getTable()->currentRow(),
                  view->getTable()->currentCol(),
                  0);
  }
  else { // try again from beginning up to current pos
    int idx = doc->search(s, view->getTable()->currentCol()-KV_EXTRA_COLS, 0, searchpos, word_beg, false);
    if (idx >= 0) {
      view->getTable()->setCurrentRow(idx, view->getTable()->currentCol());
      view->getTable()->updateViewPort();
      searchpos = idx+1;
      slotCellMoved(view->getTable()->currentRow(),
                    view->getTable()->currentCol(),
                    0);
    }
    else
      searchpos = 0;
  }

  searchstr = s;
  QApplication::restoreOverrideCursor();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotVSliderPressed (bool state, int val) /*FOLD00*/
{
   return;

   if (!state) {
     if (vslide_label != 0) {
       delete vslide_label;
       vslide_label = 0;
     }
   }
   else {
     // taken from qtooltip
     if (vslide_label == 0) {
       vslide_label = new QLabel( 0, "sliderInfo",
                           WStyle_Customize | WStyle_NoBorder );
       CHECK_PTR( vslide_label );
   /*
       label->setFont( QToolTip::font() );
   */
       QColorGroup cg( black, QColor(255,255,220),
                       QColor(96,96,96), black, black,
                       black, QColor(255,255,220) );
       vslide_label->setPalette(QPalette( cg, cg, cg ));
       if ( QApplication::style() == MotifStyle )
           vslide_label->setFrameStyle( QFrame::Plain | QFrame::Box );
       else
           vslide_label->setFrameStyle( QFrame::Raised | QFrame::Panel );
       vslide_label->setLineWidth( 1 );
       vslide_label->setMargin( 3 );
       vslide_label->setAlignment( AlignLeft | AlignTop );
       vslide_label->setAutoResize( TRUE );
     }
     slotVSliderTrackInfo (val);
   }
}


void kvoctrainApp::slotVSliderTrackInfo (int val) /*FOLD00*/
{
    return;

    if (vslide_label != 0) {
      // taken from qtooltip
      QString text;
      text.setNum(val+1);
      vslide_label->setText( text );
  
      QPoint p = QCursor::pos() + QPoint( 2, 16 );
      if ( p.x() + vslide_label->width() > QApplication::desktop()->width() )
          p.setX( QApplication::desktop()->width() - vslide_label->width() );
      if ( p.y() + vslide_label->height() > QApplication::desktop()->height() )
          p.setY( p.y() - 20 - vslide_label->height() );
      vslide_label->move( p );
      vslide_label->show();
      vslide_label->raise();
    }
}


void centerDialog( QWidget *widget, QWidget *centerParent ) /*FOLD00*/
{ 
  if( centerParent == 0 || widget == 0 )
  {
    return;
  }

  QPoint point = centerParent->mapToGlobal( QPoint(0,0) );
  QRect pos    = centerParent->geometry();
 
  widget->setGeometry( point.x() + pos.width()/2  - widget->width()/2,
		       point.y() + pos.height()/2 - widget->height()/2, 
		       widget->width(), widget->height() );
}


void kvoctrainApp::showAboutDialog( void ) /*FOLD00*/
{
  if( mAboutDialog == 0 )
  {
    mAboutDialog = new CAboutDialog( 0, "About" );
    if( mAboutDialog == 0 ) { return; }
  }
  if( mAboutDialog->isVisible() == false )
  {
    centerDialog( mAboutDialog, topLevelWidget() );
    mAboutDialog->show();
  }
  else
  {
    mAboutDialog->raise();
  }
}


void kvoctrainApp::slotViewToolBar() /*FOLD00*/
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotViewStatusBar() /*FOLD00*/
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotModified () /*FOLD00*/
{
  slotStatusMsg(IDS_DEFAULT);
}


void kvoctrainApp::slotStatusMsg(const char *text) /*FOLD00*/
{
/*
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
*/
}


void kvoctrainApp::invokeHelp( void ) /*FOLD00*/
{ 
  QFile helpfile (EA_KDEHTMLDIR ("", "default/kvoctrain/index.html"));
  if (helpfile.exists() )
    kapp->invokeHTMLHelp("kvoctrain/index.html", QString() );
  else
//   fall back to english if no native !
    kapp->invokeHTMLHelp("../en/kvoctrain/index.html", QString());
} 


void kvoctrainApp::aboutToShowLearn() { /*FOLD00*/
  learn_menu->setItemEnabled(ID_RESUME_QUERY,  query_num != 0);
  learn_menu->setItemEnabled(ID_RESUME_MULTIPLE,  query_num != 0);
}


void kvoctrainApp::aboutToShowVocabulary() { /*FOLD00*/
//  voc_menu->setItemEnabled(ID_RESUME_QUERY,  query_num != 0);
}


void kvoctrainApp::slotStatusHelpMsg(const char *text) /*FOLD00*/
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  if (!pbar)
    statusBar()->message(text, 3000);
}


void kvoctrainApp::commandCallback(int id_){ /*FOLD00*/
  switch (id_){
    ON_CMD(ID_FILE_NEW,                 slotFileNew())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_MERGE,               slotFileMerge())
    ON_CMD(ID_FILE_SAVE,                slotFileSave())
    ON_CMD(ID_FILE_SAVE_AS,             slotFileSaveAs())

    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_EDIT_COPY,                slotEditCopy())
    ON_CMD(ID_EDIT_PASTE,               slotEditPaste())
    ON_CMD(ID_SEARCH_CLIP,              slotSmartSearchClip())
    ON_CMD(ID_APPEND_ROW,               slotAppendRow())
    ON_CMD(ID_REMOVE_ROW,               slotRemoveRow())
    ON_CMD(ID_EDIT_ROW,                 slotEditRow())
    ON_CMD(ID_CLR_SEL,                  slotCancelSelection())
    ON_CMD(ID_SEL_ALL,                  slotSelectAll())
    ON_CMD(ID_SAVE_ROW,                 slotSaveSelection())

    ON_CMD(ID_APPEND_LANG,              slotAppendLang())
    ON_CMD(ID_DOC_PROPS,                slotDocProps())
    ON_CMD(ID_GENERAL_OPTIONS,          slotGeneralOptions())
    ON_CMD(ID_QUERY_OPTIONS,            slotQueryOptions())
    ON_CMD(ID_SHOW_STAT,                slotShowStatist())
    ON_CMD(ID_RAND_CREATE,              slotCreateRandom())
    ON_CMD(ID_CLEANUP,                  slotCleanVocabulary())
    ON_CMD(ID_RESUME_QUERY,             slotTimeOutRandomQuery())
    ON_CMD(ID_RESUME_MULTIPLE,          slotTimeOutMultipleChoice())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
    ON_CMD(ID_SAVE_OPTIONS,             slotSaveOptions())
  }
}


void kvoctrainApp::statusCallback(int id_){ /*FOLD00*/
  switch (id_){
    ON_STATUS_MSG(ID_FILE_NEW,          i18n("Creates a new document"))
    ON_STATUS_MSG(ID_FILE_OPEN,         i18n("Opens an existing document"))
    ON_STATUS_MSG(ID_FILE_MERGE,        i18n("Merges an existing document to the current vacabulary"))
    ON_STATUS_MSG(ID_FILE_SAVE,         i18n("Saves the current document"))
    ON_STATUS_MSG(ID_FILE_SAVE_AS,      i18n("Saves the document as..."))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))

    ON_STATUS_MSG(ID_EDIT_COPY,         i18n("Copys the selected section to the clipboard"))
    ON_STATUS_MSG(ID_EDIT_PASTE,        i18n("Pastes the clipboard contents to the end"))
    ON_STATUS_MSG(ID_SEARCH_CLIP,       i18n("Searches clipboard contents in vocabulary"))
    ON_STATUS_MSG(ID_APPEND_ROW,        i18n("Appends new entry to vocabulary"))
    ON_STATUS_MSG(ID_REMOVE_ROW,        i18n("Removes selected entries from the vocabulary"))
    ON_STATUS_MSG(ID_EDIT_ROW,          i18n("Edits properties of current selection"))
    ON_STATUS_MSG(ID_SAVE_ROW,          i18n("Writes selected rows to a file"))
    ON_STATUS_MSG(ID_SEL_ALL,           i18n("Selects all entries"))
    ON_STATUS_MSG(ID_CLR_SEL,           i18n("Un-Selects all entries"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the current Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
    ON_STATUS_MSG(ID_SAVE_OPTIONS,      i18n("Saves options"))
    ON_STATUS_MSG(ID_DOC_PROPS,         i18n("Edits document properties"))

    ON_STATUS_MSG(ID_APPEND_LANG,       i18n("Appends a column for a new language to the table"))
    ON_STATUS_MSG(ID_GENERAL_OPTIONS,   i18n("Shows general options dialog"))
    ON_STATUS_MSG(ID_QUERY_OPTIONS,     i18n("Shows query options dialog"))
    ON_STATUS_MSG(ID_SEARCH,            i18n("Enters smart search mode"))
    ON_STATUS_MSG(ID_SHOW_STAT,         i18n("Shows statistics"))
    ON_STATUS_MSG(ID_RAND_CREATE,       i18n("Creates random lessons with unassigned entries"))
    ON_STATUS_MSG(ID_CLEANUP,           i18n("Removes entries with same content from vocabulary"))
    ON_STATUS_MSG(ID_RESUME_QUERY,      i18n("Resumes random query with existing selection"))
    ON_STATUS_MSG(ID_RESUME_MULTIPLE,   i18n("Resumes multiple choice with existing selection"))
  }
}


/////////////////////////////////////////////
