#ifndef ONLINE_H
#define ONLINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define KV_HTTP_LEVEL  "1.0"

#include <vector.h>
#include <qstring.h>
#include <qobject.h>

class KSocket;
class QTimer;

class OnlineDictionary : public QObject
{
  Q_OBJECT

 private:
  OnlineDictionary();  // forbidden

 public:

  OnlineDictionary (QString servername, int portnum);
  virtual ~OnlineDictionary ();

  void closeConnection();
  virtual bool sendQuery (QString expr) = 0;
  bool sendQueryUrl (QString url);

  virtual vector<QString> getResults () = 0;
  QString getMessage () const;
  void parseContent();

  int timeoutVal() const { return 4; }
  bool isConnected() const { return sock != 0; }
  bool timedOut() const { return tout; }

 public slots:
  void writeEvent(KSocket *sock);
  void readEvent(KSocket*);
  void closeEvent(KSocket*);
  void slotTimeout();

 protected:
  void initSocket();

 private:

  QTimer   *timeout;
  KSocket  *sock;
  QString   mesg;
  bool      tout;
  QString   server;
  int       port;
};


class LEO_Dictionary : public OnlineDictionary
{

 public:
  LEO_Dictionary (QString servername = "dict.leo.org", int portnum = 80);

  virtual vector<QString> getResults ();
  virtual bool sendQuery (QString expr);

};

#endif // ONLINE_H
