/***************************************************************************
                      GenOptPage.h  -  general options dialog page
                             -------------------                                         
    begin                : Thu Jun 3 18:08:56 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef GenOptPage_included
#define GenOptPage_included

#include "GenOptPageData.h"
#include "kvoctrainview.h"
#include "compat_2x.h" // string type macro 

class GenOptPage : public GenOptPageData
{
    Q_OBJECT

public:

    GenOptPage
    (
        int         _btime,
        kvoctrainView::Resizer resizer,
        bool        _smartAppend,
        QWidget    *parent = NULL,
        const char *name = NULL
    );

    virtual ~GenOptPage();

    int getBackupTime()       const { return btime; }
    int getSmartAppend()      const { return smart; }
    kvoctrainView::Resizer getResizer() const { return resizer; }

public slots:
    virtual void initFocus() const;

protected:
    void keyPressEvent( QKeyEvent * );

protected slots:

    virtual void slotHBfixed();
    virtual void slotHBpercent();
    virtual void slotHBauto();
    virtual void slotChangeBTime(EA_QTSTR);
    virtual void slotSmartAppend(bool);

protected:

    QValidator              *validator;
    int                      btime;
    kvoctrainView::Resizer   resizer;
    bool                     smart;
};

#endif // GenOptPage_included
