/***************************************************************************
                      LangOptPage.cpp  -  language options dialog page
                             -------------------                                         
    begin                : Thu Jun 3 18:09:06 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "LangOptPage.h"
#include "resource.h"
#include <qpixmap.h>
#include <qkeycode.h>
#include <kfiledialog.h>
#include <kapp.h>

#ifdef EA_KDE2x
#include <kmessagebox.h>
#include <kstddirs.h>
#else
#include <kmsgbox.h>
#endif

#include <qfileinfo.h>

#include "langset.h"

#define Inherited LangOptPageData


LangOptPage::LangOptPage
(
        QString    _deflang,
        LangSet    &_langset,
        QString    &lastPix,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name ),
        langset (_langset),
        lastPixName(lastPix)
{
  deflang = _deflang;

  setCaption(i18n("Options" ));

  for (int i = 0; i < (int) langset.size() && i < MAX_LANGSET; i++)
    d_shortName->insertItem (langset.shortId(i));

  if (d_shortName->count() ) {
    d_shortName->setCurrentItem(0);

    e_langLong->setText(langset.longId(0));
    e_shortName2->setText(langset.shortId2(0));
    if (!langset.PixMapFile(0).isEmpty() ) {
      QPixmap pix(langset.PixMapFile(0));
      if (!pix.isNull() ) {
        lastPixName = langset.PixMapFile(0);
        b_langPixmap->setPixmap (pix);
      }
      else
        b_langPixmap->setText (i18n("invalid"));
    }
  }
  else {
    b_langPixmap->setText (i18n("not selected"));
    b_langPixmap->setEnabled(false);
  }

  label_shortName2->setBuddy(e_shortName2);
  label_shortName->setBuddy(d_shortName);
  label_langLong->setBuddy(e_langLong);
  label_langPixmap->setBuddy(b_langPixmap);
}


LangOptPage::~LangOptPage()
{
}


void LangOptPage::initFocus() const
{
  d_shortName->setFocus();
}


void LangOptPage::slotDeleteClicked()
{
  if (d_shortName->count() ) {
    d_shortName->removeItem (d_shortName->currentItem());
    langset.erase (d_shortName->currentItem());
    d_shortName->setCurrentItem (0);
  }

  if (d_shortName->count() ) {
    setPixmap(langset.PixMapFile(d_shortName->currentItem()));
    e_langLong->setText(langset.longId(d_shortName->currentItem()));
    e_shortName2->setText(langset.shortId2(d_shortName->currentItem()));
  }
  else {
    b_langPixmap->setText (i18n("not selected"));
    e_langLong->setText("");
    e_shortName2->setText("");
    b_langPixmap->setEnabled(false);
  }
}


void LangOptPage::slotNewClicked()
{
   d_shortName->insertItem(d_shortName->currentText());
   d_shortName->setCurrentItem(d_shortName->count()-1);
   slotShortActivated(d_shortName->currentText());
}


void LangOptPage::slotShortActivated(EA_QTSTR _id)
{
   QString id = _id;
   int i = 0;
   id = id.stripWhiteSpace();
   if (d_shortName->count() > (int) langset.size() ) {
     // avoid doublettes with language code
     for (i = 0; i < d_shortName->count(); i++)
       if (!strcmp (d_shortName->text(i), "") ) {
         d_shortName->removeItem(d_shortName->currentItem());
         d_shortName->setCurrentItem(0);
       }
  
     for (i = 0; i < d_shortName->count()-1; i++)  // omit last
       if (!strcmp (id, d_shortName->text(i)) ) {
         d_shortName->removeItem(d_shortName->currentItem());
         d_shortName->setCurrentItem(i);
         return;
       }
  
     if (d_shortName->count() > (int) langset.size()
         && langset.size() < MAX_LANGSET ) {
       langset.addSet (id, "", "");
     }
   }

   if (d_shortName->count() != 0) {
     deflang = id;
     b_langPixmap->setEnabled(true);
     e_langLong->setText (langset.longId(d_shortName->currentItem()));
     e_shortName2->setText (langset.shortId2(d_shortName->currentItem()));

     if (!langset.PixMapFile(d_shortName->currentItem()).isEmpty() ) {
       QPixmap pix (langset.PixMapFile(d_shortName->currentItem()));
       if (!pix.isNull() )
         b_langPixmap->setPixmap (pix);
       else
         b_langPixmap->setText (i18n("invalid"));
     }
     else
       b_langPixmap->setText (i18n("not selected"));
   }
}


void LangOptPage::slotLangChanged(EA_QTSTR s)
{
  if (d_shortName->currentItem() < (int) langset.size() )
    langset.setLongId(s, d_shortName->currentItem());
}


void LangOptPage::slotShort2Changed(EA_QTSTR s)
{
  if (d_shortName->currentItem() < (int) langset.size() )
    langset.setShortId2(s, d_shortName->currentItem());
}


bool LangOptPage::setPixmap(QString pm)
{
  if (d_shortName->count() ) {
    QPixmap pix (pm);
    if (!pix.isNull() ) {
      langset.setPixMapFile(pm, d_shortName->currentItem());
      b_langPixmap->setPixmap (pix);
      return true;
    }
  }
  return false;

}


void LangOptPage::slotPixmapClicked()
{
  if (langset.size() > 0 ) {
    // lots of flags come with kcmlocale, lets try to use them !
    if (lastPixName.isNull() ) {
      lastPixName = EA_KDEDATADIR ("", "/kcmlocale/pics/");
      if (!langset.shortId(d_shortName->currentItem()).isNull() )
        lastPixName.append("flag_"+langset.shortId(d_shortName->currentItem())+".gif");
    }
    else {
      QFileInfo fi (lastPixName);
      lastPixName = fi.dirPath()+"/flag_"+langset.shortId(d_shortName->currentItem())+".gif";
    }
    QString s = KFileDialog::getOpenFileName (lastPixName, "*.xpm *.gif *.xbm");
    if (!s.isEmpty() ) {
      if (setPixmap (s) )
        lastPixName = s;
      else {
        b_langPixmap->setText (i18n("invalid"));
#ifdef EA_KDE2x
        KMessageBox::sorry(this, i18n("kvoctrain"),
           i18n("File does not contain a valid graphics format\n"));
#else
        KMsgBox::message(this, i18n("kvoctrain"),
           i18n("File does not contain a valid graphics format\n"),
           KMsgBox::EXCLAMATION);
#endif
      }
    }
  }
}

void LangOptPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
