/***************************************************************************
                      LangOptPage.h  -  language options dialog page
                             -------------------                                         
    begin                : Thu Jun 3 18:09:06 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef LangOptPage_included
#define LangOptPage_included

#include "LangOptPageData.h"
#include <qvalidator.h>
#include "langset.h"

class LangOptPage : public LangOptPageData
{
    Q_OBJECT

public:

    LangOptPage
    (
        QString    deflang,
        LangSet    &langset,
        QString    &lastpix,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~LangOptPage();

    QString getDefaultLang () const { return deflang; }
    LangSet getLangSet ()     const { return langset; }


protected:
    void keyPressEvent( QKeyEvent *e );

public slots:
    virtual void initFocus() const;

protected slots:
    virtual void slotDeleteClicked();
    virtual void slotNewClicked();
    virtual void slotPixmapClicked();
    virtual void slotLangChanged(EA_QTSTR);
    virtual void slotShort2Changed(EA_QTSTR);
    virtual void slotShortActivated(EA_QTSTR);

protected:

    bool setPixmap(QString pm);

    QString     deflang;
    LangSet     &langset;

    QValidator *validator;
    QString    &lastPixName;

};
#endif // LangOptPage_included
