/***************************************************************************
                 BlockOptPage.cpp  -  blocking options page class
                             -------------------                                         
    begin                : Sat Oct 30 13:29:00 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "BlockOptPage.h"

#include <kapp.h>

#include <qkeycode.h>

#include "QueryManager.h"

#define Inherited BlockOptPageData

#ifndef i18n_noop
# define i18n_noop(x) (x)
#endif


struct ListRef {
          const char *text;
          long int num;
       };

static ListRef date_itemlist [] =
      { {i18n_noop("don`t care"),    0},

        {i18n_noop("30 min"),        30*60   },
        {i18n_noop("1 hour"),    1 * 60*60   },
        {i18n_noop("2 hours"),   2 * 60*60   },
        {i18n_noop("4 hours"),   4 * 60*60   },
        {i18n_noop("8 hours"),   8 * 60*60   },
        {i18n_noop("12 hours"), 12 * 60*60   },
        {i18n_noop("18 hours"), 18 * 60*60   },

        {i18n_noop("1 day"),    1 * 60*60*24},
        {i18n_noop("2 days"),   2 * 60*60*24},
        {i18n_noop("3 days"),   3 * 60*60*24},
        {i18n_noop("4 days"),   4 * 60*60*24},
        {i18n_noop("5 days"),   5 * 60*60*24},
        {i18n_noop("6 days"),   6 * 60*60*24},

        {i18n_noop("1 week"),   1 * 60*60*24*7},
        {i18n_noop("2 weeks"),  2 * 60*60*24*7},
        {i18n_noop("3 weeks"),  3 * 60*60*24*7},
        {i18n_noop("4 weeks"),  4 * 60*60*24*7},

        {i18n_noop("1 month"),  1 * 60*60*24*7*30},
        {i18n_noop("2 months"), 2 * 60*60*24*7*30},
        {i18n_noop("3 months"), 3 * 60*60*24*7*30},
        {i18n_noop("4 months"), 4 * 60*60*24*7*30},
        {i18n_noop("5 months"), 5 * 60*60*24*7*30},
        {i18n_noop("6 months"), 6 * 60*60*24*7*30},
        {i18n_noop("10 months"), 10 * 60*60*24*7*30},
        {i18n_noop("12 months"), 12 * 60*60*24*7*30},
        {0 ,  0}
      };


BlockOptPage::BlockOptPage
(
        QueryManager *_manager,
        bool          _block,
        bool          _expire,
        QWidget      *parent = NULL,
        const char   *name = NULL
)
	:
	Inherited( parent, name ),
        manager(_manager)
{
   l_lev7->setBuddy(block7);
   l_lev6->setBuddy(block6);
   l_lev5->setBuddy(block5);
   l_lev4->setBuddy(block4);
   l_lev3->setBuddy(block3);
   l_lev2->setBuddy(block2);
   l_lev1->setBuddy(block1);

   setStates (_block, _expire);
}


void BlockOptPage::setStates(bool _block, bool _expire)
{
   block = _block;
   expire = _expire;
   c_blocking->setChecked(block);
   c_expire->setChecked(expire);

   setBlockBox (1, block1);
   setBlockBox (2, block2);
   setBlockBox (3, block3);
   setBlockBox (4, block4);
   setBlockBox (5, block5);
   setBlockBox (6, block6);
   setBlockBox (7, block7);

   setExpireBox (1, expire1);
   setExpireBox (2, expire2);
   setExpireBox (3, expire3);
   setExpireBox (4, expire4);
   setExpireBox (5, expire5);
   setExpireBox (6, expire6);
   setExpireBox (7, expire7);

   block1->setEnabled(block);
   block2->setEnabled(block);
   block3->setEnabled(block);
   block4->setEnabled(block);
   block5->setEnabled(block);
   block6->setEnabled(block);
   block7->setEnabled(block);

   expire1->setEnabled(expire);
   expire2->setEnabled(expire);
   expire3->setEnabled(expire);
   expire4->setEnabled(expire);
   expire5->setEnabled(expire);
   expire6->setEnabled(expire);
   expire7->setEnabled(expire);

   emit blockExpire (c_blocking->isChecked(),
                     c_expire->isChecked() );
}


void BlockOptPage::initFocus() const
{
  c_blocking->setFocus();
}


BlockOptPage::~BlockOptPage()
{
}


void BlockOptPage::setExpireBox(int no, QComboBox *box)
{
   ListRef *ref = date_itemlist;
   int index = 0;

   box->clear();
   while (ref->text != 0 ) {
     box->insertItem (i18n(ref->text));
     if (manager->expireItem(no) == ref->num)
       index = ref - date_itemlist;
     ref++;
   }
   box->setCurrentItem (index);
}


void BlockOptPage::setBlockBox(int no, QComboBox *box)
{
   ListRef *ref = date_itemlist;
   int index = 0;

   box->clear();
   while (ref->text != 0 ) {
     box->insertItem (i18n(ref->text));
     if (manager->blockItem(no) == ref->num)
       index = ref - date_itemlist;
     ref++;
   }
   box->setCurrentItem (index);
}


void BlockOptPage::slotCheckBlock(bool state)
{
   block = state;
   setStates (block, expire);
   emit modifySetting();
}


void BlockOptPage::slotCheckExpire(bool state)
{
   expire = state;
   setStates (block, expire);
   emit modifySetting();
}


void BlockOptPage::slotSetBlock7(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV7_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire7(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV7_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetSetBlock6(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV6_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire6(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV6_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetSetBlock5(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV5_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire5(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV5_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetSetBlock4(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV4_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire4(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV4_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetBlock3(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV3_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire3(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV3_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetSetBlock2(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV2_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire2(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV2_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetSetBlock1(int idx)
{
  manager->setBlockItem(date_itemlist[idx+1].num, KV_LEV1_GRADE);
  emit modifySetting();
}


void BlockOptPage::slotSetExpire1(int idx)
{
  manager->setExpireItem(date_itemlist[idx+1].num, KV_LEV1_GRADE);
  emit modifySetting();
}


void BlockOptPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
