/***************************************************************************
               QueryOptPage.h  -  query options dialog page
                        -------------------
    begin                : Sat Jul 10 18:03:22 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "QueryOptPage.h"
#include <qvalidator.h>

#include <qkeycode.h>
#include <stdlib.h>

#include "EAGroupBox.h"

#define Inherited QueryOptPageData


#include <kapp.h>

QueryOptPage::QueryOptPage
(
        int           _mqtime,
        QueryManager *_manager,
        bool          _swapdir,
	QWidget      *parent,
	const char   *name
)
	:
	Inherited( parent, name )
{
   manager = *_manager;
   setCaption(i18n("Options" ));

   validator = new QIntValidator (0, 60*60*24*7, 0); // at least once a week

   e_mqtime->setValidator (validator);
   label_mqtime->setBuddy(e_mqtime);
   setStates(_mqtime, _swapdir);
}


void QueryOptPage::setStates(int _mqtime, bool _swapdir)
{
   swapdir = _swapdir;
   mqtime = _mqtime;

   QString s;

   s.setNum (mqtime);
   e_mqtime->setText (s);

   swap->setChecked(swapdir);
}


void QueryOptPage::initFocus() const
{
  e_mqtime->setFocus();
}


void QueryOptPage::slotChangeMQTime(EA_QTSTR s)
{
   mqtime = atoi (s);
   emit modifySetting();
}


void QueryOptPage::slotCheckSwap(bool state)
{
   swapdir = state;
   emit modifySetting();
}


QueryOptPage::~QueryOptPage()
{
}


void QueryOptPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
