/***************************************************************************
           ThreshOptPage.h  -  threshhold options dialog page
                     -------------------
    begin                : Sat Jul 10 18:03:22 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef ThreshOptPage_included
#define ThreshOptPage_included

#include "ThreshOptPageData.h"
#include "QueryManager.h"

class ThreshOptPage : public ThreshOptPageData
{
    Q_OBJECT

public:

    friend class QueryOptionsDlg;

    ThreshOptPage
    (
        QueryManager *_manager,
        QComboBox    *lessons,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    QueryManager getQueryManager()  { return manager; }

    void setStates();

    virtual ~ThreshOptPage();

protected:
    void keyPressEvent( QKeyEvent * );

signals:
     void modifySetting(int = -1);

public slots:
    virtual void initFocus() const;

protected slots:
    virtual void slotSetGradeComp(int);
    virtual void slotSetBadComp(int);
    virtual void slotSetGradeItem(int);
    virtual void slotSetBadItem(int);
    virtual void slotSetQueryComp(int);
    virtual void slotSetTypeItem(int);
    virtual void slotSetDateItem(int);
    virtual void slotSetTypeComp(int);
    virtual void slotSetQueryItem(int);
    virtual void slotSetLessonItem(int);
    virtual void slotSetLessonComp(int);
    virtual void slotSetDateComp(int);
    virtual void slotBlockExpire (bool block, bool expire);

 protected:

    QueryManager  manager;
    QComboBox    *lessons;
    vector<TypeRelation> all_maintypes;
};
#endif // ThreshOptPage_included
