/* -*- C++ -*- */

#ifndef _QTDRAW3D_H_
#define _QTDRAW3D_H_

#include <qpixmap.h>
#include <qwidget.h>
#include <qpainter.h>

#include "Draw3D.h"

/** Implementation for Qt-Library. */
class QtDraw3D : public Draw3D
{
public:
	/** Enables drawing, clears background. */
	QtDraw3D (QWidget* _widget=0);
	~QtDraw3D();

	/** @see Draw3D */
	void setForegroundColor (const Color& newColor);

	/** @see Draw3D */
	void setBackgroundColor (const Color& newColor);

	/** @see Draw3D */
	void saveInBuffer();

	/** @see Draw3D */
	void restoreBuffer();

	/** @see Draw3D */
	void startDrawing();

	/** @see Draw3D */
	void endDrawing();

	/** @see Draw3D */
	void clear();

	/** @see Draw3D */
	void updateSize();

	/** @see Draw3D */
	void updateDisplay (const int x, const int y, const int width, const int height);

	/** Sends all output to widget. */
	void connectToWidget (QWidget* _widget);


protected:

	/** Buffer which is displayed by updateDisplay in widget. */
	QPixmap *displayedBuffer;

	/** Buffer where data is stored by saveInBuffer. */
	QPixmap	*secondaryBuffer;

	/** QWidget where displayedBuffer are bitBlt. */
	QWidget *widget;

	/** Has valid context from startDrawing() to endDrawing. */
	QPainter painter;

	/** @see Draw3D */
	void drawLine2D (const int x0, const int y0,
			 const int x1, const int y1);

	/** @see Draw3D */
	void drawLineStrip2D();

	/** @see Draw3D */
	void drawFilledPolygon2D();
};

#endif _QTDRAW3D_H_
