/***************************************************************************
                          scoreboard.cpp  -  description
                             -------------------
    begin                : Thu Dec 9 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scoreboard.h"

ScoreBoard::ScoreBoard(QWidget* parent=0, const char* name=0) : QWidget(parent, name)
{
    scorePlayerOne = new QLabel(this);
    scorePlayerTwo = new QLabel(this);
    currentPlayer = new QLabel(this);
    
    scorePlayerOne->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    scorePlayerOne->setAlignment(AlignCenter);
    	
    scorePlayerTwo->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    scorePlayerTwo->setAlignment(AlignCenter);
    	
    currentPlayer->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    currentPlayer->setAlignment(AlignCenter);
    	
    setScore(0, 0);
    setPlayer(NONE);
}

void ScoreBoard::resizeEvent(QResizeEvent*)
{
	scorePlayerOne->setGeometry(0,
                                0,
                                width() * 4 / 10,   // 40% of full width
                                height());
	currentPlayer->setGeometry(scorePlayerOne->width() + 1,
                               0,
                               width() * 2 / 10,    // 20% of full width
                               height());
	scorePlayerTwo->setGeometry(currentPlayer->width() + currentPlayer->x() + 1,
                                0,
                                width() * 4 / 10,   // 40% of full width
                                height());
}

void ScoreBoard::setScore(int one, int two)
{
	QString scoreText;
	
	scoreText.sprintf(i18n("Player 1 (blue): %d"), one);
	scorePlayerOne->setText(scoreText);
	
	scoreText.sprintf(i18n("Player 2 (red): %d"), two);
	scorePlayerTwo->setText(scoreText);
}

void ScoreBoard::setPlayer(Player player)
{
	switch(player)
	{
		case ONE:
			currentPlayer->setText(i18n("Player 1"));
			break;
		case TWO:
			currentPlayer->setText(i18n("Player 2"));
			break;
		case NONE:
			currentPlayer->setText(i18n("no player"));
			break;
	}
}
