/***************************************************************************
                          token.h  -  description
                             -------------------
    begin                : Sat Jan 8 2000
    copyright            : (C) 2000 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TOKEN_H
#define TOKEN_H

/** Represents a single token
  * @author Ralf-Christian Juergensen
  */
class Token
{
private:
    void delValue(void) {if(value != 0) delete value;}
    void delTokenStr(void) {if(tokenStr != 0) delete[] tokenStr;}
public:
    Token(void) {value = 0; tokenStr = 0; isMust = false;}
    ~Token(void) {delValue(); delTokenStr();}
    void setToken(const char* str, bool must)
    {
        delTokenStr();
        tokenStr = new char[strlen(str)+1];
        strcpy(tokenStr, str);
        isMust = must;
    }
    void setValue(void* val)
    {
        delValue();
        value = val;
    }
    const void* getValue(void) {return value;}
    const char* getTokenStr(void) {return tokenStr;}
    bool isValid(void) {return !((value == 0) && isMust);}
private:
    char* tokenStr;
    void* value;
    bool isMust;
};

#endif // TOKEN_H