/***************************************************************************
                          MCursor.cc  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Jurrien Loonstra
    email                : j.h.loonstra@st.hanze.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "MCursor.h"
#include "objects.h"

#include <qbitmap.h>
#include <qstring.h>
#include <kapp.h>

#include <iostream.h>

MCursor::~MCursor() {
	delete cursor;
}

void MCursor::load(const char *name, int masked) {
	QString dir = KApplication::kde_datadir(), file, mfile;
	dir += "/kbill/";
	file.sprintf("%sbitmaps/%s.xbm", (const char*)dir, name);
	QBitmap bitmap, mask;
	if (bitmap.load(file) == FALSE) {
		cerr << "cannot open " << file << endl;
		exit(1);
	}
	if (masked == SEP_MASK) {
		mfile.sprintf ("%sbitmaps/%s_mask.xbm", (const char*)dir, name);
		if (mask.load(mfile) == FALSE) {
			cerr << "cannot open " << file << endl;
			exit(1);
		}
	}
	else
		mask = bitmap;
	cursor = new QCursor(bitmap, mask, bitmap.width() / 2, bitmap.height() / 2);
}

