#ifndef _DOLLAR_SCROLL_BAR_INCLUDED_
#define _DOLLAR_SCROLL_BAR_INCLUDED_

#include <kstring.h>
#include <qlabel.h>
#include <qscrbar.h>


class QtedDollarScrollBar : public QWidget {
   Q_OBJECT
   private:
      float      _min;
      float      _max;
      float      _inc;
      QString    _label_text;
      QLabel     *_label_p;
      QScrollBar *_sb_p;

   public:
      QtedDollarScrollBar(const char *label, float min, float max, float inc,
                         QWidget *parent=0, const char *name=0);
      void setRange(float min, float max, float inc);
      void setEnabled(bool tf) { _sb_p->setEnabled(tf); }
      void setValue(float val) { _sb_p->setValue((int)(val * 100)); }
      float getValue(void);

   protected:
      void resizeEvent(QResizeEvent *);

   private slots:
      void betMade();
      void setText(int value);


   signals:
      void valueSet(float);
};

#endif

