#ifndef _HAND_INCLUDED_
#define _HAND_INCLUDED_

#include <qlist.h>
#include "card.h"


class Hand {
   private:
      int  _soft_flag;
      int  _value;
      QList <Card>_cards;
      float _bet;
      float _insurance_bet;
      void  calculateValue(void);
   public:
      Hand() : _soft_flag(0), _bet(0.0), _insurance_bet(0.0) { }
      void addCard(Card *cp) { _cards.append(cp); calculateValue(); }
      void setBet(float bet) { _bet = bet; }
      float getBet(void) { return(_bet); }
      void setInsuranceBet(float bet) { _insurance_bet = bet; }
      float getInsuranceBet(void) { return(_insurance_bet); }
      void clear(void) { _cards.clear(); }
      Card *removeCard(void);
      void setAllCardsUp(void);
      int  isSoft(void) { return(_soft_flag); }
      int  isSplitable(void);
      int  value(void) { return(_value); }
      int  numCards(void) { return (_cards.count()); }
      QString getHelpIndex(void);
      Card *getCard(int card_num) { return (_cards.at(card_num)); }
      void draw(QPaintDevice *device_p, int x, int y);
};
    
#endif

