/***************************************************************************
                          bubble.h  -  description
                             -------------------
    begin                : Sat Jan 8 2000
    copyright            : (C) 2000 by Tony Bjrkenius
    email                : tony.bjorkenius@linux.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BUBBLE_H
#define BUBBLE_H

#include <QwSpriteField.h>
#include <qobject.h>

class Kbubbles;
class bubbleList;

class Bubble : public QObject , public QwRealMobileSprite
{
	Q_OBJECT
	public:
		Bubble(Kbubbles *par=0,QwSpritePixmapSequence *KbPixSeq=0,int col=0,int x=0,int y=0);
		~Bubble();
		int bubbleCollide();
		void setupColors();
		void checkInitFriend();
		static bubbleList *bubList;
		static int lowestBubble;
		static int colorLeft[6];
		int remove;
		int color;
		int haveWall;
		int moveDown;
	signals:
		void moveDownView();
		void deletedBubbles(int);
	private:
		static int convertColor[6];
		static int numCol;
		int getCorrectPos(int x,int y);
		int checkForFriends();
		int markBubblesRemove();
		int removeBubbles();
		void unLinkBubbles();
		void giveWall();
		Kbubbles *parent;
		int gotWall;
		int friendB;
		int locked;
		Bubble *con[6];
};

class bubbleList
{
	public:
		bubbleList(Bubble *b);
		bubbleList();
		~bubbleList();
		bubbleList *getNext();
		void setNext(bubbleList *bL);
		bubbleList *getPrev();
		void setPrev(bubbleList *bL);
		bubbleList *add(Bubble *b);
		bubbleList *remove();
		Bubble *bub;
	private:
		bubbleList *next;
		bubbleList *prev;
};
#endif
