#include "kchesswidget.h"
#include "board.h"

KChessWidget::KChessWidget(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	grid = new QGridLayout(this, 8, 8, 1);
	_board = new Board;
	whiteView = true;

	for (int i = 0; i < 8 ; i++) {
		for (int j = 0; j < 8; j++) {
			Square *s = new Square(this, i, j, _board->get(i,j));
			_square[i][j] = s;
			grid->addWidget(s, i, j);
		}
	}
	
	_engine = new Engine("crafty", this);
	show();
}

KChessWidget::~KChessWidget()
{
}

void 
KChessWidget::tellEngine(const char *move)
{
	_engine->write(move);
}

// Just make the move -- don't check for legality
void
KChessWidget::makeMove(const char *move)
{
	int r1, c1, r2, c2;
	piece promotion;

	cout << "making move: " << move << endl;

	c1 = move[0] - 'a';
	r1 = move[1] - '1';
	c2 = move[2] - 'a';
	r2 = move[3] - '1';

	if (whiteView) {
		r1 = 7 - r1;
		r2 = 7 - r2;
	}

	// Update the visuals
	_square[r2][c2]->setPiece(_board->get(r1,c1));
	_square[r1][c1]->setPiece(EmptySquare);
	_square[r1][c1]->update();
	_square[r2][c2]->update();

	// Update the data structure
	_board->set(r2, c2, _board->get(r1,c1));
	_board->set(r1,c1, EmptySquare);

	// Take care of castling
	if (strncmp(move, "e1g1", 4) == 0)
			makeMove("h1f1");
	if (strncmp(move, "e8g8", 4) == 0)
			makeMove("h8f8");
	if (strncmp(move, "e1c1", 4) == 0)
			makeMove("a1d1");
	if (strncmp(move, "e8c8", 4) == 0)
			makeMove("a8d8");

	// Pawn promotion
	switch(move[5]) {
	case 'q':
			promotion = (r2 == 1) ? WhiteQueen : BlackQueen;
			break;
	case 'b':
			promotion = (r2 == 1) ? WhiteBishop : BlackBishop;
			break;
	case 'n':
			promotion = (r2 == 1) ? WhiteKnight : BlackKnight;
			break;
	case 'r':
			promotion = (r2 == 1) ? WhiteRook : BlackRook;
			break;
	default:
			// Nothing to promote
			promotion = EmptySquare;
			break;
	}

	if (promotion != EmptySquare)
			_square[r2][c2]->setPiece(promotion);

}
