#ifndef KCHESSWIDGET_H 
#define KCHESSWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qlayout.h>

#include "engine.h"

class Board;
class Square;

/**
 * This class is the main view for KChess.  Most non-menu, non-toolbar,
 * and non-status bar GUI code should go here.
 *
 * @short Main view
 * @author Arun Sharma <adsharma@home.com>
 * @version 0.1
 */
class KChessWidget : public QWidget
{
	Q_OBJECT
public:
	/**
	 * Default constructor
	 */
	KChessWidget(QWidget *parent = 0, const char *name = 0);

	/**
	 * Destructor
	 */
	virtual ~KChessWidget();
	Board *getBoard() { return _board;};
	void makeMove(const char *move);
	void tellEngine(const char *move);

 private:
	QGridLayout *grid;
	Board *_board;
	Engine *_engine;
	Square *_square[8][8];
	bool whiteView;
};

#endif // KCHESSWIDGET_H 
