#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <qwidget.h>
#include <qpushbt.h>
#include <qevent.h>
#include <iostream.h>
#include <kmsgbox.h>
#include <kmenubar.h>

enum color{Empty, Yellow, Red};
enum direction{horizontal, vertical, diagonal_1, diagonal_2, no_dir};

class MainWidget : public QWidget
{
    Q_OBJECT
private:
    color board[7][6];
    int cs_id,ps_id,gbp_id,gbc_id,tb_id,ss_id,ds_id,ls_id;
    int l1_id,l2_id,l3_id;
    bool four_on_a_row;
    int move[7];
    int height[7];
    direction di;
    int maximum(int[]);
    int move_yellow[21],move_red[21];
    int move_nr_red,move_nr_yellow;
    KMsgBox * winwidget;

    int max_level, board_width;
    int GamePath[5];
    int score[5];
    int counter, max_score;
        
    QPixmap pixmap_red;
    QPixmap pixmap_yellow;
    QPixmap pixmap_blue;
public:
    MainWidget(QWidget * parent = 0, const char * name = 0);
    KMenuBar * menu;
    QPopupMenu * filemenu;
    QPopupMenu * optionsmenu;
    QPopupMenu * movemenu;
    QPopupMenu * levelmenu;

    int sublevel, prev_sublevel;
    void computerMove();
    bool tooHigh();
    bool end_tree;
    bool first_time;
    void moveDown();
    void moveRight();
    void remove();
    void remove(int);
    void increment();
    int computeScore();
    void resetScore(int);
    void changeScore(int, int);
    void changeUpScore(int, int);
    int prevMove(int);
    int levels_up;
    bool ready,debug;
    
    void drawCircle(int, int, QBrush);
    void initBoard();
    bool isWinner(color);
    void movePlayer(int i);
    int onARow(color, int, int);
    void endGame(color);
    void rowClicked(int);
protected:
    void paintEvent(QPaintEvent *);
    void mousePressEvent(QMouseEvent *);
    void resizeEvent(QResizeEvent *);
public slots:
    void newGame();
    void fileQuit();
    void compStarts();
    void defaultSize();
    void gameBoardPixmap();
    void gameBoardColor();
    void largeSize();
    void playerStarts();
    void smallSize();
    void takeBack();
    void level1();
    void level2();
    void level3();
};

#endif