/***************************************************************************
                          kfun21view.h  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Son Jan 24 23:06:19 CET 1999
                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KFUN21VIEW_H 
#define KFUN21VIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>
#include <qstrlist.h>
#include "patience.h"
#include <qtextstream.h>
/** The Basic Class for Card games with high scores, multiple levels and rounds
  *@author Henning Busacker
*/
class Kfun21View : public dealer
{
  Q_OBJECT

public:
/** Constructor for the main view */
	Kfun21View(QWidget *parent = 0, const char *name = 0);
/** Destructor for the main view */
	virtual ~Kfun21View();
	virtual QStrList* levelNames()=0;
/** returns the current selected speed */
	int Speed(){return speed;};
/** returns the current round count */
	int Round(){return round;};

public slots:
/** show Game */
    virtual void show();
    virtual void setSpeed(int);
/** call this when the game starts */
    void slotGameRunning();

protected slots:
    /** start next game */
    virtual void restart();
    /** display Total Score */
    virtual void showTotalScore(int){};
    /** slotfinished(const char* game, const int points) */
    void slotFinished(const char*, const int);
    /** set the Maximum Round Count (default 2)
        call before slotFinished */
    void setMaxRound(short);

public:
 signals:
    void signalTotalScore(int);

    /** signalFinished(const char* game, const char* level, const int points) */
    void signalFinished(const char*,const int);
 
protected:
    /** resizeEvent for the main view */
    virtual void resizeEvent(QResizeEvent *evt);
    /** start next round */
    virtual void deal(){  QTextStream cout( stdout, IO_WriteOnly );
                         cout << "Kfun21View.deal"<<endl;};
    void setCaption();
    Deck* deck;
    QStrList* levelnames;
private:
    /** holds the total score for this game */
    int	totalscore;
    /** holds the actual round count */
    short round;
    /** holds the maximum allowed number of round for this game */
    short maxround;
    /** actual selected Speed */
    int speed;
    /** holds the new setted Speed */
    int nspeed;
    /** marks the game as running */
    bool running;
};

#endif // KFUN21VIEW_H 




















