/***************************************************************************
                          qrolistbox.h  -  description                              
                             -------------------                                         

    version              : 0.1
    begin                : Sat May 1 1999                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QROLISTBOX_H
#define QROLISTBOX_H

#include <qlistbox.h>
#include <qlineedit.h>

/** Ein editierbarer Listboxeintrag.
    funktioniert derzeit nur bei nichtscrollbarer Listbox
  *@author Henning Busacker
 */
class EditListBoxItem : public QLineEdit,public QListBoxText {
	Q_OBJECT
public:
/** Erzeuge den Listboxeintrag */
	EditListBoxItem(QListBox* parent,const char * Text);

/** Das Ende eines Eintrags */
	virtual ~EditListBoxItem();

/** setzen der Zeile in der Listbox */
	void setPos(int);
/** liefet die H;oumlhe des Listboxeintrags */
	virtual int height(const QListBox*l);
/** liefert die Breite des Listboxeintrags */
	virtual int width(const QListBox*l);
signals:
/* sendet Text aus der Editzeile wenn Return bettigt wurde */
	void returnText(const char *);
	void ReturnPressed();
protected:
	virtual void paint(QPainter*);
	virtual void keyPressEvent ( QKeyEvent * );

private slots:
	void slotReturnPressed();
private:
friend class QListBox;
	QListBox* par;
};

/**Eine Listbox, die nur zum Anzeigen von Daten dient.
Sie kann nicht selektiert werden.
  *@author Henning Busacker
  */
class QROListbox : public QListBox  {
        Q_OBJECT
public:
	QROListbox(QWidget * parent=0, const char * name=0, WFlags f=0 );
	virtual ~QROListbox();
protected:
        virtual void mousePressEvent ( QMouseEvent * e );
	virtual void KeyPressEvent ( QKeyEvent * e );
};

#endif









